/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.tree.AnnotationNode;
import org.jruby.org.objectweb.asm.tree.FieldInsnNode;
import org.jruby.org.objectweb.asm.tree.FrameNode;
import org.jruby.org.objectweb.asm.tree.IincInsnNode;
import org.jruby.org.objectweb.asm.tree.InsnList;
import org.jruby.org.objectweb.asm.tree.InsnNode;
import org.jruby.org.objectweb.asm.tree.IntInsnNode;
import org.jruby.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jruby.org.objectweb.asm.tree.JumpInsnNode;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.org.objectweb.asm.tree.LdcInsnNode;
import org.jruby.org.objectweb.asm.tree.LineNumberNode;
import org.jruby.org.objectweb.asm.tree.LocalVariableNode;
import org.jruby.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.MethodInsnNode;
import org.jruby.org.objectweb.asm.tree.MethodNode$1;
import org.jruby.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.jruby.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jruby.org.objectweb.asm.tree.TypeInsnNode;
import org.jruby.org.objectweb.asm.tree.VarInsnNode;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List exceptions;
    public List visibleAnnotations;
    public List invisibleAnnotations;
    public List attrs;
    public Object annotationDefault;
    public List[] visibleParameterAnnotations;
    public List[] invisibleParameterAnnotations;
    public InsnList instructions;
    public List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List localVariables;
    private boolean visited;

    public MethodNode() {
        this(262144);
    }

    public MethodNode(int n) {
        super(n);
        this.instructions = new InsnList();
    }

    public MethodNode(int n, String string2, String string3, String string4, String[] stringArray) {
        this(262144, n, string2, string3, string4, stringArray);
    }

    public MethodNode(int n, int n2, String string2, String string3, String string4, String[] stringArray) {
        super(n);
        boolean bl;
        this.access = n2;
        this.name = string2;
        this.desc = string3;
        this.signature = string4;
        this.exceptions = new ArrayList(stringArray == null ? 0 : stringArray.length);
        boolean bl2 = bl = (n2 & 0x400) != 0;
        if (!bl) {
            this.localVariables = new ArrayList(5);
        }
        this.tryCatchBlocks = new ArrayList();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
        this.instructions = new InsnList();
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode(new MethodNode$1(this, 0));
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string2);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList(1);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList(1);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string2);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n2 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n2];
            }
            if (this.visibleParameterAnnotations[n] == null) {
                this.visibleParameterAnnotations[n] = new ArrayList(1);
            }
            this.visibleParameterAnnotations[n].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n3];
            }
            if (this.invisibleParameterAnnotations[n] == null) {
                this.invisibleParameterAnnotations[n] = new ArrayList(1);
            }
            this.invisibleParameterAnnotations[n].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList(1);
        }
        this.attrs.add(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.instructions.add(new FrameNode(n, n2, objectArray == null ? null : this.getLabelNodes(objectArray), n3, objectArray2 == null ? null : this.getLabelNodes(objectArray2)));
    }

    public void visitInsn(int n) {
        this.instructions.add(new InsnNode(n));
    }

    public void visitIntInsn(int n, int n2) {
        this.instructions.add(new IntInsnNode(n, n2));
    }

    public void visitVarInsn(int n, int n2) {
        this.instructions.add(new VarInsnNode(n, n2));
    }

    public void visitTypeInsn(int n, String string2) {
        this.instructions.add(new TypeInsnNode(n, string2));
    }

    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        this.instructions.add(new FieldInsnNode(n, string2, string3, string4));
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        this.instructions.add(new MethodInsnNode(n, string2, string3, string4));
    }

    public void visitInvokeDynamicInsn(String string2, String string3, Handle handle, Object ... objectArray) {
        this.instructions.add(new InvokeDynamicInsnNode(string2, string3, handle, objectArray));
    }

    public void visitJumpInsn(int n, Label label2) {
        this.instructions.add(new JumpInsnNode(n, this.getLabelNode(label2)));
    }

    public void visitLabel(Label label2) {
        this.instructions.add(this.getLabelNode(label2));
    }

    public void visitLdcInsn(Object object) {
        this.instructions.add(new LdcInsnNode(object));
    }

    public void visitIincInsn(int n, int n2) {
        this.instructions.add(new IincInsnNode(n, n2));
    }

    public void visitTableSwitchInsn(int n, int n2, Label label2, Label ... labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n, n2, this.getLabelNode(label2), this.getLabelNodes(labelArray)));
    }

    public void visitLookupSwitchInsn(Label label2, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(this.getLabelNode(label2), nArray, this.getLabelNodes(labelArray)));
    }

    public void visitMultiANewArrayInsn(String string2, int n) {
        this.instructions.add(new MultiANewArrayInsnNode(string2, n));
    }

    public void visitTryCatchBlock(Label label2, Label label3, Label label4, String string2) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(this.getLabelNode(label2), this.getLabelNode(label3), this.getLabelNode(label4), string2));
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label2, Label label3, int n) {
        this.localVariables.add(new LocalVariableNode(string2, string3, string4, this.getLabelNode(label2), this.getLabelNode(label3), n));
    }

    public void visitLineNumber(int n, Label label2) {
        this.instructions.add(new LineNumberNode(n, this.getLabelNode(label2)));
    }

    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    public void visitEnd() {
    }

    protected LabelNode getLabelNode(Label label2) {
        if (!(label2.info instanceof LabelNode)) {
            label2.info = new LabelNode();
        }
        return (LabelNode)label2.info;
    }

    private LabelNode[] getLabelNodes(Label[] labelArray) {
        LabelNode[] labelNodeArray = new LabelNode[labelArray.length];
        for (int j = 0; j < labelArray.length; ++j) {
            labelNodeArray[j] = this.getLabelNode(labelArray[j]);
        }
        return labelNodeArray;
    }

    private Object[] getLabelNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int j = 0; j < objectArray.length; ++j) {
            Object object = objectArray[j];
            if (object instanceof Label) {
                object = this.getLabelNode((Label)object);
            }
            objectArray2[j] = object;
        }
        return objectArray2;
    }

    public void check(int n) {
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor != null) {
            this.accept(methodVisitor);
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        AnnotationNode annotationNode;
        int n;
        int n2;
        Object object;
        if (this.annotationDefault != null) {
            object = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept((AnnotationVisitor)object, null, this.annotationDefault);
            if (object != null) {
                ((AnnotationVisitor)object).visitEnd();
            }
        }
        int n3 = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (AnnotationNode)this.visibleAnnotations.get(n2);
            ((AnnotationNode)object).accept(methodVisitor.visitAnnotation(((AnnotationNode)object).desc, true));
        }
        n3 = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (AnnotationNode)this.invisibleAnnotations.get(n2);
            ((AnnotationNode)object).accept(methodVisitor.visitAnnotation(((AnnotationNode)object).desc, false));
        }
        n3 = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.visibleParameterAnnotations[n2];
            if (object == null) continue;
            for (n = 0; n < object.size(); ++n) {
                annotationNode = (AnnotationNode)object.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, true));
            }
        }
        n3 = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.invisibleParameterAnnotations[n2];
            if (object == null) continue;
            for (n = 0; n < object.size(); ++n) {
                annotationNode = (AnnotationNode)object.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, false));
            }
        }
        if (this.visited) {
            this.instructions.resetLabels();
        }
        n3 = this.attrs == null ? 0 : this.attrs.size();
        for (n2 = 0; n2 < n3; ++n2) {
            methodVisitor.visitAttribute((Attribute)this.attrs.get(n2));
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            n3 = this.tryCatchBlocks == null ? 0 : this.tryCatchBlocks.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(n2)).accept(methodVisitor);
            }
            this.instructions.accept(methodVisitor);
            n3 = this.localVariables == null ? 0 : this.localVariables.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ((LocalVariableNode)this.localVariables.get(n2)).accept(methodVisitor);
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
            this.visited = true;
        }
        methodVisitor.visitEnd();
    }
}

