/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.byref;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.TypeAlias;
import jnr.ffi.byref.AbstractNumberReference;

public class NumberByReference
extends AbstractNumberReference<Number> {
    private final TypeAlias typeAlias;

    public NumberByReference(TypeAlias typeAlias, Number value2) {
        super(NumberByReference.checkNull(value2));
        this.typeAlias = typeAlias;
    }

    public NumberByReference(TypeAlias typeAlias) {
        super(0);
        this.typeAlias = typeAlias;
    }

    @Override
    public int nativeSize(Runtime runtime) {
        return runtime.findType(this.typeAlias).size();
    }

    @Override
    public void toNative(Runtime runtime, Pointer memory, long offset2) {
        switch (runtime.findType(this.typeAlias).getNativeType()) {
            case SCHAR: 
            case UCHAR: {
                this.value = memory.getByte(offset2);
                break;
            }
            case SSHORT: 
            case USHORT: {
                this.value = memory.getShort(offset2);
                break;
            }
            case SINT: 
            case UINT: {
                this.value = memory.getInt(offset2);
                break;
            }
            case SLONG: 
            case ULONG: {
                this.value = memory.getLong(offset2);
                break;
            }
            case SLONGLONG: 
            case ULONGLONG: {
                this.value = memory.getLongLong(offset2);
                break;
            }
            case ADDRESS: {
                this.value = memory.getAddress(offset2);
                break;
            }
            case FLOAT: {
                this.value = Float.valueOf(memory.getFloat(offset2));
                break;
            }
            case DOUBLE: {
                this.value = memory.getDouble(offset2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported type: " + (Object)((Object)this.typeAlias));
            }
        }
    }

    @Override
    public void fromNative(Runtime runtime, Pointer memory, long offset2) {
        switch (runtime.findType(this.typeAlias).getNativeType()) {
            case SCHAR: 
            case UCHAR: {
                memory.putByte(offset2, this.value.byteValue());
                break;
            }
            case SSHORT: 
            case USHORT: {
                memory.putShort(offset2, this.value.shortValue());
                break;
            }
            case SINT: 
            case UINT: {
                memory.putInt(offset2, this.value.intValue());
                break;
            }
            case SLONG: 
            case ULONG: {
                memory.putLong(offset2, this.value.longValue());
                break;
            }
            case SLONGLONG: 
            case ULONGLONG: {
                memory.putLongLong(offset2, this.value.longValue());
                break;
            }
            case ADDRESS: {
                memory.putAddress(offset2, this.value.longValue());
                break;
            }
            case FLOAT: {
                memory.putFloat(offset2, this.value.floatValue());
                break;
            }
            case DOUBLE: {
                memory.putDouble(offset2, this.value.doubleValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported type: " + (Object)((Object)this.typeAlias));
            }
        }
    }
}

