/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class EQQInstr
extends TwoOperandResultBaseInstr
implements FixedArityInstr {
    public EQQInstr(Variable result2, Operand v1, Operand v2) {
        super(Operation.EQQ, result2, v1, v2);
        assert (result2 != null) : "EQQInstr result is null";
    }

    public Operand getArg1() {
        return this.getOperand1();
    }

    public Operand getArg2() {
        return this.getOperand2();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new EQQInstr(ii.getRenamedVariable(this.result), this.getArg1().cloneForInlining(ii), this.getArg2().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getArg1());
        e.encode(this.getArg2());
    }

    public static EQQInstr decode(IRReaderDecoder d) {
        return new EQQInstr(d.decodeVariable(), d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        return IRRuntimeHelpers.isEQQ(context, (IRubyObject)this.getArg1().retrieve(context, self2, currScope, currDynScope, temp), (IRubyObject)this.getArg2().retrieve(context, self2, currScope, currDynScope, temp));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.EQQInstr(this);
    }
}

