/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.FiberQueue;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ThreadFiber
extends RubyObject
implements ExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadFiber.class);
    volatile FiberData data;
    volatile RubyThread thread;

    public ThreadFiber(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public static void initRootFiber(ThreadContext context, RubyThread currentThread) {
        Ruby runtime2 = context.runtime;
        ThreadFiber rootFiber = new ThreadFiber(runtime2, runtime2.getFiber());
        rootFiber.data = new FiberData(new FiberQueue(runtime2), currentThread, rootFiber);
        rootFiber.thread = currentThread;
        context.setRootFiber(rootFiber);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            throw runtime2.newArgumentError("tried to create Proc object without block");
        }
        this.data = new FiberData(new FiberQueue(runtime2), context.getFiberCurrentThread(), this);
        FiberData currentFiberData = context.getFiber().data;
        this.thread = ThreadFiber.createThread(runtime2, this.data, currentFiberData.queue, block);
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject resume(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime2 = context.runtime;
        FiberData data2 = this.data;
        if (data2.prev != null || data2.transferred) {
            throw runtime2.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime2.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (data2 == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return RubyArray.newArrayMayCopy(runtime2, values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = RubyArray.newArrayMayCopy(runtime2, values2);
            }
        }
        if (data2.parent != context.getFiberCurrentThread()) {
            throw runtime2.newFiberError("fiber called across threads");
        }
        data2.prev = context.getFiber();
        try {
            IRubyObject iRubyObject = ThreadFiber.exchangeWithFiber(context, currentFiberData, data2, val);
            return iRubyObject;
        }
        finally {
            data2.prev = null;
        }
    }

    private static IRubyObject exchangeWithFiber(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, IRubyObject val) {
        try {
            targetFiberData.queue.push(context, new IRubyObject[]{val});
        }
        catch (RaiseException re) {
            ThreadFiber.handleExceptionDuringExchange(context, currentFiberData, targetFiberData, re);
        }
        while (true) {
            try {
                IRubyObject result2 = currentFiberData.queue.pop(context);
                return result2 == NEVER ? context.nil : result2;
            }
            catch (RaiseException re) {
                ThreadFiber.handleExceptionDuringExchange(context, currentFiberData, targetFiberData, re);
                continue;
            }
            break;
        }
    }

    private static void handleExceptionDuringExchange(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, RaiseException re) {
        if (context.runtime.getLocalJumpError().isInstance(re.getException())) {
            throw re;
        }
        if (currentFiberData.queue.isShutdown()) {
            throw re;
        }
        if (targetFiberData.queue.isShutdown()) {
            throw re;
        }
        ThreadFiber fiber2 = (ThreadFiber)targetFiberData.fiber.get();
        if (fiber2 != null && fiber2.alive()) {
            fiber2.thread.raise(re.getException());
        } else {
            LOG.warn("no fiber thread to raise: {}", re.getException().inspect(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject __transfer__(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime2 = context.runtime;
        FiberData data2 = this.data;
        if (data2.prev != null) {
            throw runtime2.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime2.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (data2 == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return RubyArray.newArrayMayCopy(runtime2, values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = RubyArray.newArrayMayCopy(runtime2, values2);
            }
        }
        if (data2.parent != context.getFiberCurrentThread()) {
            throw runtime2.newFiberError("fiber called across threads");
        }
        if (currentFiberData.prev != null) {
            data2.prev = currentFiberData.prev;
            currentFiberData.prev = null;
            currentFiberData.transferred = true;
        } else {
            data2.prev = context.getFiber();
        }
        try {
            IRubyObject iRubyObject = ThreadFiber.exchangeWithFiber(context, currentFiberData, data2, val);
            return iRubyObject;
        }
        finally {
            data2.prev = null;
            currentFiberData.transferred = false;
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2) {
        return ThreadFiber.yield(context, recv2, context.nil);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
        Ruby runtime2 = context.runtime;
        FiberData currentFiberData = context.getFiber().data;
        if (currentFiberData.parent == null) {
            throw runtime2.newFiberError("can't yield from root fiber");
        }
        if (currentFiberData.prev == null) {
            throw runtime2.newFiberError("BUG: yield occurred with null previous fiber. Report this at http://bugs.jruby.org");
        }
        if (currentFiberData.queue.isShutdown()) {
            throw runtime2.newFiberError("dead fiber yielded");
        }
        FiberData prevFiberData = currentFiberData.prev.data;
        return ThreadFiber.exchangeWithFiber(context, currentFiberData, prevFiberData, value2);
    }

    @JRubyMethod
    public IRubyObject __alive__(ThreadContext context) {
        return context.runtime.newBoolean(this.alive());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __current__(ThreadContext context, IRubyObject recv2) {
        return context.getFiber();
    }

    @Override
    public Map<Object, IRubyObject> getContextVariables() {
        return this.thread.getContextVariables();
    }

    final boolean alive() {
        RubyThread thread2 = this.thread;
        return thread2 != null && thread2.isAlive() && !this.data.queue.isShutdown();
    }

    static RubyThread createThread(final Ruby runtime2, final FiberData data2, FiberQueue queue, final Block block) {
        final AtomicReference fiberThread = new AtomicReference();
        boolean retried = true;
        try {
            runtime2.getFiberExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block15: {
                        ThreadContext context = runtime2.getCurrentContext();
                        context.setFiber((ThreadFiber)data2.fiber.get());
                        context.useRecursionGuardsFrom(data2.parent.getContext());
                        fiberThread.set(context.getThread());
                        context.getThread().setFiberCurrentThread(data2.parent);
                        try {
                            IRubyObject init = data2.queue.pop(context);
                            try {
                                IRubyObject result2 = init == RubyBasicObject.NEVER ? block.yieldSpecific(context) : block.yieldArray(context, init, null);
                                ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                                if (tf != null) {
                                    tf.thread = null;
                                }
                                data2.prev.data.queue.push(context, new IRubyObject[]{result2});
                                data2.queue.shutdown();
                                runtime2.getThreadService().unregisterCurrentThread(context);
                            }
                            catch (Throwable throwable) {
                                data2.queue.shutdown();
                                runtime2.getThreadService().unregisterCurrentThread(context);
                                ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                                if (tf != null) {
                                    tf.thread = null;
                                }
                                throw throwable;
                            }
                            ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                            if (tf != null) {
                                tf.thread = null;
                            }
                        }
                        catch (JumpException.FlowControlException fce) {
                            if (data2.prev != null) {
                                data2.prev.thread.raise(fce.buildException(runtime2).getException());
                            }
                        }
                        catch (IRBreakJump bj) {
                            if (data2.prev != null) {
                                data2.prev.thread.raise(((RaiseException)IRException.BREAK_LocalJumpError.getException(runtime2)).getException());
                            }
                        }
                        catch (IRReturnJump rj) {
                            if (data2.prev != null) {
                                data2.prev.thread.raise(((RaiseException)IRException.RETURN_LocalJumpError.getException(runtime2)).getException());
                            }
                        }
                        catch (RaiseException re) {
                            if (data2.prev != null) {
                                data2.prev.thread.raise(re.getException());
                            }
                        }
                        catch (Throwable t) {
                            if (data2.prev == null) break block15;
                            data2.prev.thread.raise(JavaUtil.convertJavaToUsableRubyObject(runtime2, t));
                        }
                    }
                }
            });
        }
        catch (OutOfMemoryError oome) {
            String oomeMessage = oome.getMessage();
            if (!retried && oomeMessage != null && oomeMessage.contains("unable to create new native thread")) {
                System.gc();
                retried = true;
            }
            throw oome;
        }
        while (fiberThread.get() == null) {
            Thread.yield();
        }
        return (RubyThread)fiberThread.get();
    }

    protected void finalize() throws Throwable {
        try {
            RubyThread thread2;
            FiberData data2 = this.data;
            if (data2 != null) {
                if (data2.parent == null) {
                    return;
                }
                data2.queue.shutdown();
            }
            if ((thread2 = this.thread) != null) {
                thread2.dieFromFinalizer();
                thread2.interrupt();
                data2 = null;
                Object var2_2 = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    public FiberData getData() {
        return this.data;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public static class FiberData {
        final FiberQueue queue;
        volatile ThreadFiber prev;
        final RubyThread parent;
        final WeakReference<ThreadFiber> fiber;
        volatile boolean transferred;

        FiberData(FiberQueue queue, RubyThread parent, ThreadFiber fiber2) {
            this.queue = queue;
            this.parent = parent;
            this.fiber = new WeakReference<ThreadFiber>(fiber2);
        }

        public ThreadFiber getPrev() {
            return this.prev;
        }
    }
}

