/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Arrays;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.MultiBranchInstr;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BSwitchInstr
extends MultiBranchInstr {
    private final Operand[] jumpOperands;
    private final int[] jumps;
    private Operand operand;
    private final Label rubyCase;
    private final Label[] targets;
    private final Label elseTarget;
    private final Class expectedClass;

    public BSwitchInstr(int[] jumps, Operand[] jumpOperands, Operand operand, Label rubyCase, Label[] targets, Label elseTarget, Class expectedClass) {
        super(Operation.B_SWITCH);
        assert (BSwitchInstr.jumpsAreSorted(jumps)) : "jump table must be sorted";
        assert (operand != null) : "Switch cases must not have an empty \"case\" value";
        this.jumpOperands = jumpOperands;
        this.jumps = jumps;
        this.operand = operand;
        this.rubyCase = rubyCase;
        this.targets = targets;
        this.elseTarget = elseTarget;
        this.expectedClass = expectedClass;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.operand};
    }

    public Operand getCaseOperand() {
        return this.operand;
    }

    public int[] getJumps() {
        return this.jumps;
    }

    public Label getRubyCaseLabel() {
        return this.rubyCase;
    }

    public Label[] getTargets() {
        return this.targets;
    }

    public Label getElseTarget() {
        return this.elseTarget;
    }

    public Class getExpectedClass() {
        return this.expectedClass;
    }

    @Override
    public void setOperand(int i2, Operand operand) {
        assert (i2 == 0);
        this.operand = operand;
    }

    @Override
    public Instr clone(CloneInfo info) {
        Operand operand = this.operand.cloneForInlining(info);
        Label rubyCase = info.getRenamedLabel(this.rubyCase);
        Label[] targets = new Label[this.targets.length];
        for (int i2 = 0; i2 < targets.length; ++i2) {
            targets[i2] = info.getRenamedLabel(this.targets[i2]);
        }
        Label elseTarget = info.getRenamedLabel(this.elseTarget);
        return new BSwitchInstr(this.jumps, this.jumpOperands, operand, rubyCase, targets, elseTarget, this.expectedClass);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.jumpOperands);
        e.encode(this.operand);
        e.encode(this.rubyCase);
        e.encode(this.targets);
        e.encode(this.elseTarget);
        e.encode(this.expectedClass.getName());
    }

    public static BSwitchInstr decode(IRReaderDecoder d) {
        try {
            Operand[] jumpOperands = d.decodeOperandArray();
            Operand operand = d.decodeOperand();
            Label rubyCase = d.decodeLabel();
            Label[] targets = d.decodeLabelArray();
            Label elseTarget = d.decodeLabel();
            Class<?> expectedClass = Class.forName(d.decodeString());
            int[] jumps = new int[jumpOperands.length];
            for (int i2 = 0; i2 < jumps.length; ++i2) {
                Operand jumpOperand = jumpOperands[i2];
                if (jumpOperand instanceof Symbol) {
                    jumps[i2] = ((Symbol)jumpOperand).getSymbol().getId();
                    continue;
                }
                if (!(jumpOperand instanceof Fixnum)) continue;
                jumps[i2] = (int)((Fixnum)jumpOperand).getValue();
            }
            int[] sortedJumps = (int[])jumps.clone();
            Arrays.sort(sortedJumps);
            Operand[] sortedJumpOperands = (Operand[])jumpOperands.clone();
            Label[] sortedTargets = (Label[])targets.clone();
            for (int i3 = 0; i3 < jumps.length; ++i3) {
                int oldJump = jumps[i3];
                int newIndex = Arrays.binarySearch(sortedJumps, oldJump);
                sortedJumpOperands[newIndex] = jumpOperands[i3];
                sortedTargets[newIndex] = targets[i3];
            }
            return new BSwitchInstr(sortedJumps, sortedJumpOperands, operand, rubyCase, sortedTargets, elseTarget, expectedClass);
        }
        catch (Exception e) {
            Helpers.throwException(e);
            return null;
        }
    }

    @Override
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, StaticScope currScope, IRubyObject self2, Object[] temp, int ipc) {
        int value2;
        Object result2 = this.operand.retrieve(context, self2, currScope, currDynScope, temp);
        if (result2 instanceof RubyFixnum && this.expectedClass == RubyFixnum.class) {
            value2 = ((RubyFixnum)result2).getIntValue();
        } else if (result2 instanceof RubySymbol && this.expectedClass == RubySymbol.class) {
            value2 = ((RubySymbol)result2).getId();
        } else {
            return this.rubyCase.getTargetPC();
        }
        int index2 = Arrays.binarySearch(this.jumps, value2);
        if (index2 < 0) {
            return this.elseTarget.getTargetPC();
        }
        return this.targets[index2].getTargetPC();
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BSwitchInstr(this);
    }

    @Override
    public Label[] getJumpTargets() {
        Label[] jumpTargets = new Label[this.targets.length + 2];
        jumpTargets[0] = this.rubyCase;
        System.arraycopy(this.targets, 0, jumpTargets, 1, this.targets.length);
        jumpTargets[jumpTargets.length - 1] = this.elseTarget;
        return jumpTargets;
    }

    private static boolean jumpsAreSorted(int[] jumps) {
        if (jumps.length == 0) {
            return true;
        }
        int prev = jumps[0];
        for (int i2 = 1; i2 < jumps.length; ++i2) {
            int curr = jumps[i2];
            if (prev > curr) {
                return false;
            }
            prev = curr;
        }
        return true;
    }
}

