/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.util.StrptimeFormat;

public class StrptimeToken {
    static final StrptimeToken[] CONVERSION2TOKEN = new StrptimeToken[256];
    private final StrptimeFormat format;
    private final Object data;

    StrptimeToken(StrptimeFormat format) {
        this(format, null);
    }

    StrptimeToken(StrptimeFormat formatString, Object data2) {
        this.format = formatString;
        this.data = data2;
    }

    public static StrptimeToken str(String str) {
        return new StrptimeToken(StrptimeFormat.FORMAT_STRING, str);
    }

    public static StrptimeToken format(char c) {
        return CONVERSION2TOKEN[c];
    }

    public static StrptimeToken zoneOffsetColons(int colons) {
        return new StrptimeToken(StrptimeFormat.FORMAT_COLON_ZONE_OFF, colons);
    }

    public static StrptimeToken special(char c) {
        return new StrptimeToken(StrptimeFormat.FORMAT_SPECIAL, Character.valueOf(c));
    }

    Object getData() {
        return this.data;
    }

    StrptimeFormat getFormat() {
        return this.format;
    }

    public String toString() {
        return "<Token " + (Object)((Object)this.format) + " " + this.data + ">";
    }

    static {
        StrptimeToken.CONVERSION2TOKEN[65] = new StrptimeToken(StrptimeFormat.FORMAT_WEEK_LONG);
        StrptimeToken.CONVERSION2TOKEN[97] = new StrptimeToken(StrptimeFormat.FORMAT_WEEK_SHORT);
        StrptimeToken.CONVERSION2TOKEN[66] = new StrptimeToken(StrptimeFormat.FORMAT_MONTH_LONG);
        StrptimeToken.CONVERSION2TOKEN[98] = new StrptimeToken(StrptimeFormat.FORMAT_MONTH_SHORT);
        StrptimeToken.CONVERSION2TOKEN[104] = CONVERSION2TOKEN[98];
        StrptimeToken.CONVERSION2TOKEN[67] = new StrptimeToken(StrptimeFormat.FORMAT_CENTURY);
        StrptimeToken.CONVERSION2TOKEN[100] = new StrptimeToken(StrptimeFormat.FORMAT_DAY);
        StrptimeToken.CONVERSION2TOKEN[101] = new StrptimeToken(StrptimeFormat.FORMAT_DAY_S);
        StrptimeToken.CONVERSION2TOKEN[71] = new StrptimeToken(StrptimeFormat.FORMAT_WEEKYEAR);
        StrptimeToken.CONVERSION2TOKEN[103] = new StrptimeToken(StrptimeFormat.FORMAT_WEEKYEAR_SHORT);
        StrptimeToken.CONVERSION2TOKEN[72] = new StrptimeToken(StrptimeFormat.FORMAT_HOUR);
        StrptimeToken.CONVERSION2TOKEN[73] = new StrptimeToken(StrptimeFormat.FORMAT_HOUR_M);
        StrptimeToken.CONVERSION2TOKEN[106] = new StrptimeToken(StrptimeFormat.FORMAT_DAY_YEAR);
        StrptimeToken.CONVERSION2TOKEN[107] = new StrptimeToken(StrptimeFormat.FORMAT_HOUR_BLANK);
        StrptimeToken.CONVERSION2TOKEN[76] = new StrptimeToken(StrptimeFormat.FORMAT_MILLISEC);
        StrptimeToken.CONVERSION2TOKEN[108] = new StrptimeToken(StrptimeFormat.FORMAT_HOUR_S);
        StrptimeToken.CONVERSION2TOKEN[77] = new StrptimeToken(StrptimeFormat.FORMAT_MINUTES);
        StrptimeToken.CONVERSION2TOKEN[109] = new StrptimeToken(StrptimeFormat.FORMAT_MONTH);
        StrptimeToken.CONVERSION2TOKEN[78] = new StrptimeToken(StrptimeFormat.FORMAT_NANOSEC);
        StrptimeToken.CONVERSION2TOKEN[80] = new StrptimeToken(StrptimeFormat.FORMAT_MERIDIAN_LOWER_CASE);
        StrptimeToken.CONVERSION2TOKEN[112] = new StrptimeToken(StrptimeFormat.FORMAT_MERIDIAN);
        StrptimeToken.CONVERSION2TOKEN[81] = new StrptimeToken(StrptimeFormat.FORMAT_MICROSEC_EPOCH);
        StrptimeToken.CONVERSION2TOKEN[83] = new StrptimeToken(StrptimeFormat.FORMAT_SECONDS);
        StrptimeToken.CONVERSION2TOKEN[115] = new StrptimeToken(StrptimeFormat.FORMAT_EPOCH);
        StrptimeToken.CONVERSION2TOKEN[85] = new StrptimeToken(StrptimeFormat.FORMAT_WEEK_YEAR_S);
        StrptimeToken.CONVERSION2TOKEN[117] = new StrptimeToken(StrptimeFormat.FORMAT_DAY_WEEK2);
        StrptimeToken.CONVERSION2TOKEN[86] = new StrptimeToken(StrptimeFormat.FORMAT_WEEK_WEEKYEAR);
        StrptimeToken.CONVERSION2TOKEN[87] = new StrptimeToken(StrptimeFormat.FORMAT_WEEK_YEAR_M);
        StrptimeToken.CONVERSION2TOKEN[119] = new StrptimeToken(StrptimeFormat.FORMAT_DAY_WEEK);
        StrptimeToken.CONVERSION2TOKEN[89] = new StrptimeToken(StrptimeFormat.FORMAT_YEAR_LONG);
        StrptimeToken.CONVERSION2TOKEN[121] = new StrptimeToken(StrptimeFormat.FORMAT_YEAR_SHORT);
    }
}

