/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gems.gem;

import de.saumya.mojo.gems.gem.GemFileEntry;
import de.saumya.mojo.gems.spec.GemSpecification;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Gem {
    private final List<GemFileEntry> files = new ArrayList<GemFileEntry>();
    private final GemSpecification spec;

    public Gem(GemSpecification spec) {
        this.spec = spec;
    }

    public static String constructGemFileName(String gemName, String gemVersion, String platform) {
        StringBuilder sb = new StringBuilder();
        sb.append(gemName).append("-").append(gemVersion);
        if (platform != null && !"ruby".equals(platform)) {
            sb.append("-").append(platform);
        }
        sb.append(".gem");
        return sb.toString();
    }

    private String add(File source, String path) {
        if (!source.isFile()) {
            throw new RuntimeException("only files are implemented: " + source);
        }
        this.files.add(new GemFileEntry(source, path));
        return path;
    }

    public List<GemFileEntry> getGemFiles() {
        return this.files;
    }

    public void addFile(File source) {
        this.addFile(source, source.getPath());
    }

    public void addFile(File source, String path) {
        this.spec.addFile(this.add(source, path));
    }

    public void addTestFile(File source) {
        this.addTestFile(source, source.getPath());
    }

    public void addTestFile(File source, String path) {
        this.spec.addTestFile(this.add(source, path));
    }

    public void addExtraRdocFile(File source) {
        this.addExtraRdocFile(source, source.getPath());
    }

    public void addExtraRdocFile(File source, String path) {
        this.spec.addExtraRdocFile(this.add(source, path));
    }

    public GemSpecification getSpecification() {
        return this.spec;
    }

    public String getGemFilename() {
        return Gem.constructGemFileName(this.spec.getName(), this.spec.getVersion().toString(), this.spec.getPlatform());
    }
}

