/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ScriptUtils {
    private ScriptUtils() {
    }

    public static InputStream getScriptAsStream(String name) throws IOException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (stream == null) {
            throw new FileNotFoundException("loading resource from classloader failed: " + name);
        }
        return stream;
    }

    public static InputStream getScriptAsStream(String name, Class<?> clazz) throws IOException {
        InputStream stream = clazz.getResourceAsStream(name);
        if (stream == null) {
            return ScriptUtils.getScriptAsStream(name);
        }
        return stream;
    }

    public static URL getScriptFromResource(String name) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null) {
            throw new FileNotFoundException("loading resource from classloader failed: " + name);
        }
        return url;
    }
}

