/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.AnnotatorFactory;
import org.jsonschema2pojo.FileCodeWriterWithEncoding;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.URLProtocol;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.URLUtil;

public class Jsonschema2Pojo {
    public static void generate(GenerationConfig config) throws IOException {
        Annotator annotator = Jsonschema2Pojo.getAnnotator(config);
        RuleFactory ruleFactory = Jsonschema2Pojo.createRuleFactory(config);
        ruleFactory.setAnnotator(annotator);
        ruleFactory.setGenerationConfig(config);
        SchemaMapper mapper = new SchemaMapper(ruleFactory, new SchemaGenerator());
        JCodeModel codeModel = new JCodeModel();
        if (config.isRemoveOldOutput()) {
            Jsonschema2Pojo.removeOldOutput(config.getTargetDirectory());
        }
        Iterator<URL> sources = config.getSource();
        while (sources.hasNext()) {
            URL source = sources.next();
            if (URLUtil.parseProtocol(source.toString()) == URLProtocol.FILE && URLUtil.getFileFromURL(source).isDirectory()) {
                Jsonschema2Pojo.generateRecursive(config, mapper, codeModel, StringUtils.defaultString((String)config.getTargetPackage()), Arrays.asList(URLUtil.getFileFromURL(source).listFiles(config.getFileFilter())));
                continue;
            }
            mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(source), StringUtils.defaultString((String)config.getTargetPackage()), source);
        }
        if (!config.getTargetDirectory().exists() && !config.getTargetDirectory().mkdirs()) {
            throw new GenerationException("Could not create or access target directory " + config.getTargetDirectory().getAbsolutePath());
        }
        FileCodeWriterWithEncoding sourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
        FileCodeWriterWithEncoding resourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
        codeModel.build((CodeWriter)sourcesWriter, (CodeWriter)resourcesWriter);
    }

    private static RuleFactory createRuleFactory(GenerationConfig config) {
        Class<? extends RuleFactory> clazz = config.getCustomRuleFactory();
        if (!RuleFactory.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The class name given as a rule factory  (" + clazz.getName() + ") does not refer to a class that implements " + RuleFactory.class.getName());
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Failed to create a rule factory from the given class. An exception was thrown on trying to create a new instance.", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to create a rule factory from the given class. It appears that we do not have access to this class - is both the class and its no-arg constructor marked public?", e);
        }
    }

    private static void generateRecursive(GenerationConfig config, SchemaMapper mapper, JCodeModel codeModel, String packageName, List<File> schemaFiles) throws IOException {
        Collections.sort(schemaFiles);
        for (File child : schemaFiles) {
            if (child.isFile()) {
                mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(child.toURI().toURL()), StringUtils.defaultString((String)packageName), child.toURI().toURL());
                continue;
            }
            Jsonschema2Pojo.generateRecursive(config, mapper, codeModel, packageName + "." + child.getName(), Arrays.asList(child.listFiles(config.getFileFilter())));
        }
    }

    private static void removeOldOutput(File targetDirectory) {
        if (targetDirectory.exists()) {
            for (File f : targetDirectory.listFiles()) {
                Jsonschema2Pojo.delete(f);
            }
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void delete(File f) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                Jsonschema2Pojo.delete(child);
            }
        }
        f.delete();
    }

    private static Annotator getAnnotator(GenerationConfig config) {
        AnnotatorFactory factory = new AnnotatorFactory();
        return factory.getAnnotator(factory.getAnnotator(config.getAnnotationStyle()), factory.getAnnotator(config.getCustomAnnotator()));
    }

    private static String getNodeName(URL file) {
        try {
            return FilenameUtils.getBaseName((String)URLDecoder.decode(file.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Unable to generate node name from URL: %s", file.toString()), e);
        }
    }
}

