/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.exception.ClassAlreadyExistsException;
import org.jsonschema2pojo.rules.NameHelper;
import org.jsonschema2pojo.rules.PrimitiveTypes;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.TypeUtil;

public class ObjectRule
implements Rule<JPackage, JType> {
    private final RuleFactory ruleFactory;

    protected ObjectRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JPackage _package, Schema schema) {
        JDefinedClass jclass;
        JType superType = this.getSuperType(nodeName, node, (JClassContainer)_package, schema);
        if (superType.isPrimitive() || this.isFinal(superType)) {
            return superType;
        }
        try {
            jclass = this.createClass(nodeName, node, _package);
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
        jclass._extends((JClass)superType);
        schema.setJavaTypeIfEmpty((JType)jclass);
        this.addGeneratedAnnotation(jclass);
        if (node.has("deserializationClassProperty")) {
            this.addJsonTypeInfoAnnotation(jclass, node);
        }
        if (node.has("title")) {
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), (JDocCommentable)jclass, schema);
        }
        if (node.has("description")) {
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), (JDocCommentable)jclass, schema);
        }
        if (node.has("properties")) {
            this.ruleFactory.getPropertiesRule().apply(nodeName, node.get("properties"), jclass, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeToString()) {
            this.addToString(jclass);
        }
        if (node.has("javaInterfaces")) {
            this.addInterfaces(jclass, node.get("javaInterfaces"));
        }
        this.ruleFactory.getAdditionalPropertiesRule().apply(nodeName, node.get("additionalProperties"), jclass, schema);
        if (this.ruleFactory.getGenerationConfig().isIncludeHashcodeAndEquals()) {
            this.addHashCode(jclass);
            this.addEquals(jclass);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeConstructors()) {
            this.addConstructors(jclass, this.getConstructorProperties(node, this.ruleFactory.getGenerationConfig().isConstructorsRequiredPropertiesOnly()));
        }
        return jclass;
    }

    private List<String> getConstructorProperties(JsonNode node, boolean onlyRequired) {
        if (!node.has("properties")) {
            return new ArrayList<String>();
        }
        ArrayList<String> rtn = new ArrayList<String>();
        NameHelper nameHelper = this.ruleFactory.getNameHelper();
        Iterator properties = node.get("properties").fields();
        while (properties.hasNext()) {
            Map.Entry property = (Map.Entry)properties.next();
            JsonNode propertyObj = (JsonNode)property.getValue();
            if (onlyRequired) {
                if (!propertyObj.has("required") || !propertyObj.get("required").asBoolean()) continue;
                rtn.add(nameHelper.getPropertyName((String)property.getKey()));
                continue;
            }
            rtn.add(nameHelper.getPropertyName((String)property.getKey()));
        }
        return rtn;
    }

    private JDefinedClass createClass(String nodeName, JsonNode node, JPackage _package) throws ClassAlreadyExistsException {
        JDefinedClass newType;
        try {
            boolean usePolymorphicDeserialization = this.usesPolymorphicDeserialization(node);
            if (node.has("javaType")) {
                String fqn = StringUtils.substringBefore((String)node.get("javaType").asText(), (String)"<");
                if (PrimitiveTypes.isPrimitive(fqn, _package.owner())) {
                    throw new ClassAlreadyExistsException((JType)PrimitiveTypes.primitiveType(fqn, _package.owner()));
                }
                int index = fqn.lastIndexOf(".") + 1;
                if (index >= 0 && index < fqn.length()) {
                    fqn = fqn.substring(0, index) + this.ruleFactory.getGenerationConfig().getClassNamePrefix() + fqn.substring(index) + this.ruleFactory.getGenerationConfig().getClassNameSuffix();
                }
                try {
                    _package.owner().ref(Thread.currentThread().getContextClassLoader().loadClass(fqn));
                    JClass existingClass = TypeUtil.resolveType(_package, fqn + (node.get("javaType").asText().contains("<") ? "<" + StringUtils.substringAfter((String)node.get("javaType").asText(), (String)"<") : ""));
                    throw new ClassAlreadyExistsException((JType)existingClass);
                }
                catch (ClassNotFoundException e) {
                    newType = usePolymorphicDeserialization ? _package.owner()._class(1, fqn, ClassType.CLASS) : _package.owner()._class(fqn);
                }
            } else {
                newType = usePolymorphicDeserialization ? _package._class(1, this.getClassName(nodeName, _package), ClassType.CLASS) : _package._class(this.getClassName(nodeName, _package));
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new ClassAlreadyExistsException((JType)e.getExistingClass());
        }
        this.ruleFactory.getAnnotator().propertyInclusion(newType, node);
        return newType;
    }

    private boolean isFinal(JType superType) {
        try {
            Class<?> javaClass = Class.forName(superType.fullName());
            return Modifier.isFinal(javaClass.getModifiers());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private JType getSuperType(String nodeName, JsonNode node, JClassContainer jClassContainer, Schema schema) {
        JClass superType = jClassContainer.owner().ref(Object.class);
        if (node.has("extends")) {
            superType = this.ruleFactory.getSchemaRule().apply(nodeName + "Parent", node.get("extends"), jClassContainer, schema);
        }
        return superType;
    }

    private void addGeneratedAnnotation(JDefinedClass jclass) {
        JAnnotationUse generated = jclass.annotate(Generated.class);
        generated.param("value", SchemaMapper.class.getPackage().getName());
    }

    private void addJsonTypeInfoAnnotation(JDefinedClass jclass, JsonNode node) {
        if (this.ruleFactory.getGenerationConfig().getAnnotationStyle() == AnnotationStyle.JACKSON2) {
            String annotationName = node.get("deserializationClassProperty").asText();
            JAnnotationUse jsonTypeInfo = jclass.annotate(JsonTypeInfo.class);
            jsonTypeInfo.param("use", (Enum)JsonTypeInfo.Id.CLASS);
            jsonTypeInfo.param("include", (Enum)JsonTypeInfo.As.PROPERTY);
            jsonTypeInfo.param("property", annotationName);
        }
    }

    private void addToString(JDefinedClass jclass) {
        JMethod toString = jclass.method(1, String.class, "toString");
        Class toStringBuilder = this.ruleFactory.getGenerationConfig().isUseCommonsLang3() ? ToStringBuilder.class : org.apache.commons.lang.builder.ToStringBuilder.class;
        JBlock body = toString.body();
        JInvocation reflectionToString = jclass.owner().ref(toStringBuilder).staticInvoke("reflectionToString");
        reflectionToString.arg(JExpr._this());
        body._return((JExpression)reflectionToString);
        toString.annotate(Override.class);
    }

    private void addHashCode(JDefinedClass jclass) {
        Map fields = jclass.fields();
        if (fields.isEmpty()) {
            return;
        }
        JMethod hashCode = jclass.method(1, Integer.TYPE, "hashCode");
        Class hashCodeBuilder = this.ruleFactory.getGenerationConfig().isUseCommonsLang3() ? org.apache.commons.lang3.builder.HashCodeBuilder.class : HashCodeBuilder.class;
        JBlock body = hashCode.body();
        JClass hashCodeBuilderClass = jclass.owner().ref(hashCodeBuilder);
        JInvocation hashCodeBuilderInvocation = JExpr._new((JClass)hashCodeBuilderClass);
        for (JFieldVar fieldVar : fields.values()) {
            hashCodeBuilderInvocation = hashCodeBuilderInvocation.invoke("append").arg((JExpression)fieldVar);
        }
        body._return((JExpression)hashCodeBuilderInvocation.invoke("toHashCode"));
        hashCode.annotate(Override.class);
    }

    private void addConstructors(JDefinedClass jclass, List<String> properties) {
        if (properties.isEmpty()) {
            return;
        }
        JMethod noargsConstructor = jclass.constructor(1);
        noargsConstructor.javadoc().add((Object)"No args constructor for use in serialization");
        JMethod fieldsConstructor = jclass.constructor(1);
        JBlock constructorBody = fieldsConstructor.body();
        Map fields = jclass.fields();
        for (String property : properties) {
            JFieldVar field = (JFieldVar)fields.get(property);
            if (field == null) {
                throw new IllegalStateException("Property " + property + " hasn't been added to JDefinedClass before calling addConstructors");
            }
            fieldsConstructor.javadoc().addParam(property);
            JVar param = fieldsConstructor.param(field.type(), field.name());
            constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
        }
    }

    private void addEquals(JDefinedClass jclass) {
        Map fields = jclass.fields();
        if (fields.isEmpty()) {
            return;
        }
        JMethod equals = jclass.method(1, Boolean.TYPE, "equals");
        JVar otherObject = equals.param(Object.class, "other");
        Class equalsBuilder = this.ruleFactory.getGenerationConfig().isUseCommonsLang3() ? EqualsBuilder.class : org.apache.commons.lang.builder.EqualsBuilder.class;
        JBlock body = equals.body();
        body._if(otherObject.eq(JExpr._this()))._then()._return(JExpr.TRUE);
        body._if(otherObject._instanceof((JType)jclass).eq(JExpr.FALSE))._then()._return(JExpr.FALSE);
        JVar rhsVar = body.decl((JType)jclass, "rhs").init((JExpression)JExpr.cast((JType)jclass, (JExpression)otherObject));
        JClass equalsBuilderClass = jclass.owner().ref(equalsBuilder);
        JInvocation equalsBuilderInvocation = JExpr._new((JClass)equalsBuilderClass);
        for (JFieldVar fieldVar : fields.values()) {
            equalsBuilderInvocation = equalsBuilderInvocation.invoke("append").arg((JExpression)fieldVar).arg((JExpression)rhsVar.ref(fieldVar.name()));
        }
        JInvocation reflectionEquals = jclass.owner().ref(equalsBuilder).staticInvoke("reflectionEquals");
        reflectionEquals.arg(JExpr._this());
        reflectionEquals.arg((JExpression)otherObject);
        body._return((JExpression)equalsBuilderInvocation.invoke("isEquals"));
        equals.annotate(Override.class);
    }

    private void addInterfaces(JDefinedClass jclass, JsonNode javaInterfaces) {
        for (JsonNode i : javaInterfaces) {
            jclass._implements(jclass.owner().ref(i.asText()));
        }
    }

    private String getClassName(String nodeName, JPackage _package) {
        String className = this.ruleFactory.getNameHelper().replaceIllegalCharacters(StringUtils.capitalize((String)nodeName));
        String normalizedName = this.ruleFactory.getNameHelper().normalizeName(className);
        return this.makeUnique(normalizedName, _package);
    }

    private String makeUnique(String className, JPackage _package) {
        try {
            JDefinedClass _class = _package._class(className);
            _package.remove((JClass)_class);
            return className;
        }
        catch (JClassAlreadyExistsException e) {
            return this.makeUnique(className + "_", _package);
        }
    }

    private boolean usesPolymorphicDeserialization(JsonNode node) {
        if (this.ruleFactory.getGenerationConfig().getAnnotationStyle() == AnnotationStyle.JACKSON2) {
            return node.has("deserializationClassProperty");
        }
        return false;
    }
}

