/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FragmentResolver {
    public JsonNode resolve(JsonNode tree, String path) {
        return this.resolve(tree, new ArrayList<String>(Arrays.asList(StringUtils.split((String)path, (String)"#/."))));
    }

    private JsonNode resolve(JsonNode tree, List<String> path) {
        if (path.isEmpty()) {
            return tree;
        }
        String part = path.remove(0);
        if (tree.isArray()) {
            try {
                int index = Integer.parseInt(part);
                return this.resolve(tree.get(index), path);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Not a valid array index: " + part);
            }
        }
        if (tree.has(part)) {
            return this.resolve(tree.get(part), path);
        }
        throw new IllegalArgumentException("Path not present: " + part);
    }
}

