/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JFieldVar;
import javax.validation.constraints.NotNull;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class RequiredRule
implements Rule<JDocCommentable, JDocComment> {
    public static final String REQUIRED_COMMENT_TEXT = "\n(Required)";
    private final RuleFactory ruleFactory;

    protected RequiredRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDocComment apply(String nodeName, JsonNode node, JDocCommentable generatableType, Schema schema) {
        JDocComment javadoc = generatableType.javadoc();
        if (node.asBoolean()) {
            javadoc.append((Object)REQUIRED_COMMENT_TEXT);
            if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations() && generatableType instanceof JFieldVar) {
                ((JFieldVar)generatableType).annotate(NotNull.class);
            }
        }
        return javadoc;
    }
}

