/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.AdditionalPropertiesRule;
import org.jsonschema2pojo.rules.ArrayRule;
import org.jsonschema2pojo.rules.DefaultRule;
import org.jsonschema2pojo.rules.DescriptionRule;
import org.jsonschema2pojo.rules.DynamicPropertiesRule;
import org.jsonschema2pojo.rules.EnumRule;
import org.jsonschema2pojo.rules.FormatRule;
import org.jsonschema2pojo.rules.JavaNameRule;
import org.jsonschema2pojo.rules.MediaRule;
import org.jsonschema2pojo.rules.MinItemsMaxItemsRule;
import org.jsonschema2pojo.rules.MinLengthMaxLengthRule;
import org.jsonschema2pojo.rules.MinimumMaximumRule;
import org.jsonschema2pojo.rules.ObjectRule;
import org.jsonschema2pojo.rules.PatternRule;
import org.jsonschema2pojo.rules.PropertiesRule;
import org.jsonschema2pojo.rules.PropertyRule;
import org.jsonschema2pojo.rules.RequiredArrayRule;
import org.jsonschema2pojo.rules.RequiredRule;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.SchemaRule;
import org.jsonschema2pojo.rules.TitleRule;
import org.jsonschema2pojo.rules.TypeRule;
import org.jsonschema2pojo.rules.ValidRule;
import org.jsonschema2pojo.util.NameHelper;
import org.jsonschema2pojo.util.ParcelableHelper;

public class RuleFactory {
    private NameHelper nameHelper;
    private GenerationConfig generationConfig;
    private Annotator annotator;
    private SchemaStore schemaStore;

    public RuleFactory(GenerationConfig generationConfig, Annotator annotator, SchemaStore schemaStore) {
        this.generationConfig = generationConfig;
        this.annotator = annotator;
        this.schemaStore = schemaStore;
        this.nameHelper = new NameHelper(generationConfig);
    }

    public RuleFactory() {
        this(new DefaultGenerationConfig(), new Jackson2Annotator(), new SchemaStore());
    }

    public Rule<JPackage, JClass> getArrayRule() {
        return new ArrayRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getDescriptionRule() {
        return new DescriptionRule();
    }

    public Rule<JClassContainer, JType> getEnumRule() {
        return new EnumRule(this);
    }

    public Rule<JType, JType> getFormatRule() {
        return new FormatRule(this);
    }

    public Rule<JPackage, JType> getObjectRule() {
        return new ObjectRule(this, new ParcelableHelper());
    }

    public Rule<JDefinedClass, JDefinedClass> getRequiredArrayRule() {
        return new RequiredArrayRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getPropertiesRule() {
        return new PropertiesRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getPropertyRule() {
        return new PropertyRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getRequiredRule() {
        return new RequiredRule(this);
    }

    public Rule<JClassContainer, JType> getTypeRule() {
        return new TypeRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getAdditionalPropertiesRule() {
        return new AdditionalPropertiesRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getTitleRule() {
        return new TitleRule();
    }

    public Rule<JClassContainer, JType> getSchemaRule() {
        return new SchemaRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getDefaultRule() {
        return new DefaultRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getMinimumMaximumRule() {
        return new MinimumMaximumRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getMinItemsMaxItemsRule() {
        return new MinItemsMaxItemsRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getMinLengthMaxLengthRule() {
        return new MinLengthMaxLengthRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getPatternRule() {
        return new PatternRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getValidRule() {
        return new ValidRule(this);
    }

    public GenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public void setGenerationConfig(GenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
        this.nameHelper = new NameHelper(generationConfig);
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(Annotator annotator) {
        this.annotator = annotator;
    }

    public SchemaStore getSchemaStore() {
        return this.schemaStore;
    }

    public void setSchemaStore(SchemaStore schemaStore) {
        this.schemaStore = schemaStore;
    }

    public NameHelper getNameHelper() {
        return this.nameHelper;
    }

    public Rule<JType, JType> getMediaRule() {
        return new MediaRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getDynamicPropertiesRule() {
        return new DynamicPropertiesRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getJavaNameRule() {
        return new JavaNameRule();
    }
}

