/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsonschema2pojo.util.RuleAndReplacement;

public class Inflector {
    private static final Pattern UNDERSCORE_PATTERN_1 = Pattern.compile("([A-Z]+)([A-Z][a-z])");
    private static final Pattern UNDERSCORE_PATTERN_2 = Pattern.compile("([a-z\\d])([A-Z])");
    private static List<RuleAndReplacement> plurals = new ArrayList<RuleAndReplacement>();
    private static List<RuleAndReplacement> singulars = new ArrayList<RuleAndReplacement>();
    private static List<String> uncountables = new ArrayList<String>();
    private static Inflector instance;

    private Inflector() {
        this.initialize();
    }

    private void initialize() {
        Inflector.plural("$", "s");
        Inflector.plural("s$", "s");
        Inflector.plural("(ax|test)is$", "$1es");
        Inflector.plural("(octop|vir)us$", "$1i");
        Inflector.plural("(alias|status)$", "$1es");
        Inflector.plural("(bu)s$", "$1es");
        Inflector.plural("(buffal|tomat)o$", "$1oes");
        Inflector.plural("([ti])um$", "$1a");
        Inflector.plural("sis$", "ses");
        Inflector.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        Inflector.plural("(hive)$", "$1s");
        Inflector.plural("([^aeiouy]|qu)y$", "$1ies");
        Inflector.plural("([^aeiouy]|qu)ies$", "$1y");
        Inflector.plural("(x|ch|ss|sh)$", "$1es");
        Inflector.plural("(matr|vert|ind)ix|ex$", "$1ices");
        Inflector.plural("([m|l])ouse$", "$1ice");
        Inflector.plural("(ox)$", "$1en");
        Inflector.plural("(quiz)$", "$1zes");
        Inflector.singular("s$", "");
        Inflector.singular("(n)ews$", "$1ews");
        Inflector.singular("([ti])a$", "$1um");
        Inflector.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        Inflector.singular("(^analy)ses$", "$1sis");
        Inflector.singular("([^f])ves$", "$1fe");
        Inflector.singular("(hive)s$", "$1");
        Inflector.singular("(tive)s$", "$1");
        Inflector.singular("([lr])ves$", "$1f");
        Inflector.singular("([^aeiouy]|qu)ies$", "$1y");
        Inflector.singular("(s)eries$", "$1eries");
        Inflector.singular("(m)ovies$", "$1ovie");
        Inflector.singular("(x|ch|ss|sh)es$", "$1");
        Inflector.singular("([m|l])ice$", "$1ouse");
        Inflector.singular("(bus)es$", "$1");
        Inflector.singular("(o)es$", "$1");
        Inflector.singular("(shoe)s$", "$1");
        Inflector.singular("(cris|ax|test)es$", "$1is");
        Inflector.singular("([octop|vir])i$", "$1us");
        Inflector.singular("(alias|status)es$", "$1");
        Inflector.singular("^(ox)en", "$1");
        Inflector.singular("(vert|ind)ices$", "$1ex");
        Inflector.singular("(matr)ices$", "$1ix");
        Inflector.singular("(quiz)zes$", "$1");
        Inflector.singular("men$", "man");
        Inflector.plural("man$", "men");
        Inflector.irregular("curve", "curves");
        Inflector.irregular("leaf", "leaves");
        Inflector.irregular("roof", "rooves");
        Inflector.irregular("person", "people");
        Inflector.irregular("child", "children");
        Inflector.irregular("sex", "sexes");
        Inflector.irregular("move", "moves");
        Inflector.uncountable("equipment", "information", "rice", "money", "species", "series", "fish", "sheep", "s");
    }

    public static Inflector getInstance() {
        if (instance == null) {
            instance = new Inflector();
        }
        return instance;
    }

    public String underscore(String camelCasedWord) {
        String underscoredWord = UNDERSCORE_PATTERN_1.matcher(camelCasedWord).replaceAll("$1_$2");
        underscoredWord = UNDERSCORE_PATTERN_2.matcher(underscoredWord).replaceAll("$1_$2");
        underscoredWord = underscoredWord.replace('-', '_').toLowerCase();
        return underscoredWord;
    }

    public String pluralize(String word) {
        if (uncountables.contains(word.toLowerCase())) {
            return word;
        }
        return this.replaceWithFirstRule(word, plurals);
    }

    public String singularize(String word) {
        if (uncountables.contains(word.toLowerCase())) {
            return word;
        }
        return this.replaceWithFirstRule(word, singulars);
    }

    private String replaceWithFirstRule(String word, List<RuleAndReplacement> ruleAndReplacements) {
        for (RuleAndReplacement rar : ruleAndReplacements) {
            String rule = rar.getRule();
            String replacement = rar.getReplacement();
            Matcher matcher = Pattern.compile(rule, 2).matcher(word);
            if (!matcher.find()) continue;
            return matcher.replaceAll(replacement);
        }
        return word;
    }

    public String tableize(String className) {
        return this.pluralize(this.underscore(className));
    }

    public String tableize(Class<?> klass) {
        String className = klass.getName().replace(klass.getPackage().getName() + ".", "");
        return this.tableize(className);
    }

    public static void plural(String rule, String replacement) {
        plurals.add(0, new RuleAndReplacement(rule, replacement));
    }

    public static void singular(String rule, String replacement) {
        singulars.add(0, new RuleAndReplacement(rule, replacement));
    }

    public static void irregular(String singular, String plural) {
        Inflector.plural(singular, plural);
        Inflector.singular(plural, singular);
    }

    public static void uncountable(String ... words) {
        for (String word : words) {
            uncountables.add(word);
        }
    }
}

