/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jsonschema2pojo.model.EnumDefinitionExtensionType;
import org.jsonschema2pojo.model.EnumValueDefinition;

public class EnumDefinition {
    private final JType backingType;
    private final ArrayList<EnumValueDefinition> enumValues;
    private final String nodeName;
    private final JsonNode enumNode;
    private final EnumDefinitionExtensionType type;

    public EnumDefinition(String nodeName, JsonNode enumNode, JType backingType, ArrayList<EnumValueDefinition> enumValues, EnumDefinitionExtensionType type) {
        this.nodeName = nodeName;
        this.enumNode = enumNode;
        this.backingType = backingType;
        this.enumValues = enumValues;
        this.type = type;
    }

    public EnumDefinition(EnumDefinition enumDefinition) {
        this(enumDefinition, enumDefinition.enumValues);
    }

    public EnumDefinition(EnumDefinition enumDefinition, ArrayList<EnumValueDefinition> enumValueDefinitions) {
        this(enumDefinition.nodeName, enumDefinition.enumNode, enumDefinition.backingType, enumValueDefinitions, enumDefinition.type);
    }

    public JType getBackingType() {
        return this.backingType;
    }

    public JsonNode getEnumNode() {
        return this.enumNode;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public EnumDefinitionExtensionType getType() {
        return this.type;
    }

    public int size() {
        if (this.enumValues != null) {
            return this.enumValues.size();
        }
        return 0;
    }

    public Collection<EnumValueDefinition> values() {
        if (this.enumValues != null) {
            return Collections.unmodifiableCollection(this.enumValues);
        }
        return Collections.emptyList();
    }
}

