/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JFieldVar;
import jakarta.validation.constraints.Digits;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class DigitsRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    protected DigitsRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations() && node.has("integerDigits") && node.has("fractionalDigits") && this.isApplicableType(field)) {
            Class digitsClass = this.ruleFactory.getGenerationConfig().isUseJakartaValidation() ? Digits.class : javax.validation.constraints.Digits.class;
            JAnnotationUse annotation = field.annotate(digitsClass);
            annotation.param("integer", node.get("integerDigits").asInt());
            annotation.param("fraction", node.get("fractionalDigits").asInt());
        }
        return field;
    }

    private boolean isApplicableType(JFieldVar field) {
        try {
            Class<?> fieldClass = Class.forName(field.type().boxify().fullName());
            return String.class.isAssignableFrom(fieldClass) || Number.class.isAssignableFrom(fieldClass) && !Float.class.isAssignableFrom(fieldClass) && !Double.class.isAssignableFrom(fieldClass);
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

