/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.MatchPatterns;

public class MatchPatternsFileFilter
implements FileFilter {
    MatchPatterns includePatterns;
    MatchPatterns excludePatterns;
    String sourceDirectory;
    boolean caseSensitive;

    MatchPatternsFileFilter(MatchPatterns includePatterns, MatchPatterns excludePatterns, String sourceDirectory, boolean caseSensitive) {
        this.includePatterns = includePatterns;
        this.excludePatterns = excludePatterns;
        this.sourceDirectory = sourceDirectory;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean accept(File file) {
        try {
            String path = this.relativePath(file);
            return file.isDirectory() ? this.includePatterns.matchesPatternStart(path, this.caseSensitive) && !this.excludePatterns.matchesPatternStart(path, this.caseSensitive) : this.includePatterns.matches(path, this.caseSensitive) && !this.excludePatterns.matches(path, this.caseSensitive);
        }
        catch (IOException e) {
            return false;
        }
    }

    String relativePath(File file) throws IOException {
        String canonicalPath = file.getCanonicalPath();
        if (!canonicalPath.startsWith(this.sourceDirectory)) {
            throw new IOException(String.format("the path %s is not a decendent of the basedir %s", canonicalPath, this.sourceDirectory));
        }
        return canonicalPath.substring(this.sourceDirectory.length()).replaceAll("^" + Pattern.quote(File.separator), "");
    }

    static List<String> processPatterns(List<String> patterns) {
        if (patterns == null) {
            return null;
        }
        ArrayList<String> processed = new ArrayList<String>();
        for (String pattern : patterns) {
            processed.add(MatchPatternsFileFilter.processPattern(pattern));
        }
        return processed;
    }

    static String processPattern(String pattern) {
        return pattern.trim().replace('/', File.separatorChar).replace('\\', File.separatorChar).replaceAll(Pattern.quote(File.separator) + "$", File.separator + "**");
    }

    public static class Builder {
        List<String> includes = new ArrayList<String>();
        List<String> excludes = new ArrayList<String>();
        String sourceDirectory;
        boolean caseSensitive;

        public Builder addIncludes(List<String> includes) {
            this.includes.addAll(MatchPatternsFileFilter.processPatterns(includes));
            return this;
        }

        public Builder addIncludes(String ... includes) {
            if (includes != null) {
                this.addIncludes(Arrays.asList(includes));
            }
            return this;
        }

        public Builder addExcludes(List<String> excludes) {
            this.excludes.addAll(MatchPatternsFileFilter.processPatterns(excludes));
            return this;
        }

        public Builder addExcludes(String ... excludes) {
            if (excludes != null) {
                this.addExcludes(Arrays.asList(excludes));
            }
            return this;
        }

        public Builder addDefaultExcludes() {
            this.excludes.addAll(MatchPatternsFileFilter.processPatterns(Arrays.asList(DirectoryScanner.DEFAULTEXCLUDES)));
            return this;
        }

        public Builder withSourceDirectory(String canonicalSourceDirectory) {
            this.sourceDirectory = canonicalSourceDirectory;
            return this;
        }

        public Builder withCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public MatchPatternsFileFilter build() {
            if (this.includes.isEmpty()) {
                this.includes.add(MatchPatternsFileFilter.processPattern("**/*"));
            }
            return new MatchPatternsFileFilter(MatchPatterns.from((String[])this.includes.toArray(new String[0])), MatchPatterns.from((String[])this.excludes.toArray(new String[0])), this.sourceDirectory, this.caseSensitive);
        }
    }
}

