/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.AssertionUtils;

class AssertEquals {
    private AssertEquals() {
    }

    static void assertEquals(byte expected, byte actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(byte expected, byte actual, @Nullable String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(byte expected, byte actual, Supplier<@Nullable String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(char expected, char actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(char expected, char actual, @Nullable String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(Character.valueOf(expected), Character.valueOf(actual), message);
        }
    }

    static void assertEquals(char expected, char actual, Supplier<@Nullable String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(Character.valueOf(expected), Character.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(double expected, double actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(double expected, double actual, @Nullable String message) {
        if (!AssertionUtils.doublesAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(double expected, double actual, Supplier<@Nullable String> messageSupplier) {
        if (!AssertionUtils.doublesAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(double expected, double actual, double delta) {
        AssertEquals.assertEquals(expected, actual, delta, (String)null);
    }

    static void assertEquals(double expected, double actual, double delta, @Nullable String message) {
        if (!AssertionUtils.doublesAreEqual(expected, actual, delta)) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(double expected, double actual, double delta, Supplier<@Nullable String> messageSupplier) {
        if (!AssertionUtils.doublesAreEqual(expected, actual, delta)) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(float expected, float actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(float expected, float actual, @Nullable String message) {
        if (!AssertionUtils.floatsAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), message);
        }
    }

    static void assertEquals(float expected, float actual, Supplier<@Nullable String> messageSupplier) {
        if (!AssertionUtils.floatsAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(float expected, float actual, float delta) {
        AssertEquals.assertEquals(expected, actual, delta, (String)null);
    }

    static void assertEquals(float expected, float actual, float delta, @Nullable String message) {
        if (!AssertionUtils.floatsAreEqual(expected, actual, delta)) {
            AssertEquals.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), message);
        }
    }

    static void assertEquals(float expected, float actual, float delta, Supplier<@Nullable String> messageSupplier) {
        if (!AssertionUtils.floatsAreEqual(expected, actual, delta)) {
            AssertEquals.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), messageSupplier);
        }
    }

    static void assertEquals(short expected, short actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(short expected, short actual, @Nullable String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(short expected, short actual, Supplier<@Nullable String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(int expected, int actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(int expected, int actual, @Nullable String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(int expected, int actual, Supplier<@Nullable String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(long expected, long actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(long expected, long actual, @Nullable String message) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(long expected, long actual, Supplier<@Nullable String> messageSupplier) {
        if (expected != actual) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    static void assertEquals(@Nullable Object expected, @Nullable Object actual) {
        AssertEquals.assertEquals(expected, actual, (String)null);
    }

    static void assertEquals(@Nullable Object expected, @Nullable Object actual, @Nullable String message) {
        if (!AssertionUtils.objectsAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(expected, actual, message);
        }
    }

    static void assertEquals(@Nullable Object expected, @Nullable Object actual, Supplier<@Nullable String> messageSupplier) {
        if (!AssertionUtils.objectsAreEqual(expected, actual)) {
            AssertEquals.failNotEqual(expected, actual, messageSupplier);
        }
    }

    private static void failNotEqual(@Nullable Object expected, @Nullable Object actual, @Nullable Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).expected(expected).actual(actual).buildAndThrow();
    }
}

