/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.platform.commons.annotation.Contract;

class AssertFalse {
    private AssertFalse() {
    }

    @Contract(value="true -> fail")
    static void assertFalse(boolean condition) {
        AssertFalse.assertFalse(condition, (String)null);
    }

    @Contract(value="true, _ -> fail")
    static void assertFalse(boolean condition, @Nullable String message) {
        if (condition) {
            AssertFalse.failNotFalse(message);
        }
    }

    @Contract(value="true, _ -> fail")
    static void assertFalse(boolean condition, Supplier<@Nullable String> messageSupplier) {
        if (condition) {
            AssertFalse.failNotFalse(messageSupplier);
        }
    }

    static void assertFalse(BooleanSupplier booleanSupplier) {
        AssertFalse.assertFalse(booleanSupplier.getAsBoolean(), (String)null);
    }

    static void assertFalse(BooleanSupplier booleanSupplier, @Nullable String message) {
        AssertFalse.assertFalse(booleanSupplier.getAsBoolean(), message);
    }

    static void assertFalse(BooleanSupplier booleanSupplier, Supplier<@Nullable String> messageSupplier) {
        AssertFalse.assertFalse(booleanSupplier.getAsBoolean(), messageSupplier);
    }

    private static void failNotFalse(@Nullable Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).expected(false).actual(true).buildAndThrow();
    }
}

