/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.script;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;

@API(status=API.Status.INTERNAL, since="5.1")
public interface ScriptAccessor {
    public String get(String var1);

    public static class ConfigurationParameterAccessor
    implements ScriptAccessor {
        private final ExtensionContext context;

        public ConfigurationParameterAccessor(ExtensionContext context) {
            this.context = context;
        }

        @Override
        public String get(String key) {
            return this.context.getConfigurationParameter(key).orElse(null);
        }
    }

    public static class EnvironmentVariableAccessor
    implements ScriptAccessor {
        @Override
        public String get(String name) {
            return System.getenv(name);
        }
    }

    public static class SystemPropertyAccessor
    implements ScriptAccessor {
        @Override
        public String get(String name) {
            return System.getProperty(name);
        }
    }
}

