/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.surefire.provider;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ConsoleStream;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.surefire.provider.RunListenerAdapter;
import org.junit.platform.surefire.provider.TestMethodFilter;
import org.junit.platform.surefire.provider.TestPlanScannerFilter;

@Deprecated
@API(status=API.Status.DEPRECATED, since="1.3")
public class JUnitPlatformProvider
extends AbstractProvider {
    static final String EXCLUDE_GROUPS = "excludedGroups";
    static final String EXCLUDE_TAGS = "excludeTags";
    static final String INCLUDE_GROUPS = "groups";
    static final String INCLUDE_TAGS = "includeTags";
    static final String CONFIGURATION_PARAMETERS = "configurationParameters";
    static final String EXCEPTION_MESSAGE_BOTH_NOT_ALLOWED = "The groups and includeTags parameters (or the excludedGroups and excludeTags parameters) are synonyms - only one of each is allowed (though neither is required).";
    private final ProviderParameters parameters;
    private final Launcher launcher;
    final Filter<?>[] filters;
    final Map<String, String> configurationParameters;

    public JUnitPlatformProvider(ProviderParameters parameters) {
        this(parameters, LauncherFactory.create());
    }

    JUnitPlatformProvider(ProviderParameters parameters, Launcher launcher) {
        this.parameters = parameters;
        this.launcher = launcher;
        this.filters = this.getFilters();
        this.configurationParameters = this.getConfigurationParameters();
        Logger.getLogger("org.junit").setLevel(Level.WARNING);
        this.printDeprecationWarning(parameters);
    }

    private void printDeprecationWarning(ProviderParameters parameters) {
        ConsoleStream consoleLogger = parameters.getConsoleLogger();
        consoleLogger.println(String.join((CharSequence)System.lineSeparator(), "", " +-------------------------------------------------------------------------------+", " | WARNING:                                                                      |", " | The junit-platform-surefire-provider has been deprecated and is scheduled to  |", " | be removed in JUnit Platform 1.4. Please use the built-in support in Maven    |", " | Surefire >= 2.22.0 instead.                                                   |", " | \u00bb https://junit.org/junit5/docs/current/user-guide/#running-tests-build-maven |", " +-------------------------------------------------------------------------------+", "", ""));
    }

    public Iterable<Class<?>> getSuites() {
        return this.scanClasspath();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException, InvocationTargetException {
        if (forkTestSet instanceof TestsToRun) {
            return this.invokeAllTests((TestsToRun)forkTestSet);
        }
        if (forkTestSet instanceof Class) {
            return this.invokeAllTests(TestsToRun.fromClass((Class)((Class)forkTestSet)));
        }
        if (forkTestSet == null) {
            return this.invokeAllTests(this.scanClasspath());
        }
        throw new IllegalArgumentException("Unexpected value of forkTestSet: " + forkTestSet);
    }

    private TestsToRun scanClasspath() {
        TestPlanScannerFilter filter = new TestPlanScannerFilter(this.launcher, this.filters);
        ScanResult scanResult = this.parameters.getScanResult();
        TestsToRun scannedClasses = scanResult.applyFilter((ScannerFilter)filter, this.parameters.getTestClassLoader());
        return this.parameters.getRunOrderCalculator().orderTestClasses(scannedClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult invokeAllTests(TestsToRun testsToRun) {
        RunResult runResult;
        ReporterFactory reporterFactory = this.parameters.getReporterFactory();
        try {
            RunListener runListener = reporterFactory.createReporter();
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)runListener));
            LauncherDiscoveryRequest discoveryRequest = this.buildLauncherDiscoveryRequest(testsToRun);
            this.launcher.execute(discoveryRequest, new TestExecutionListener[]{new RunListenerAdapter(runListener)});
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    private LauncherDiscoveryRequest buildLauncherDiscoveryRequest(TestsToRun testsToRun) {
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request().filters(this.filters).configurationParameters(this.configurationParameters);
        for (Class testClass : testsToRun) {
            builder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((Class)testClass)});
        }
        return builder.build();
    }

    private Filter<?>[] getFilters() {
        ArrayList<TestMethodFilter> filters = new ArrayList<TestMethodFilter>();
        Optional<List<String>> includes = this.getGroupsOrTags(this.getPropertiesList(INCLUDE_GROUPS), this.getPropertiesList(INCLUDE_TAGS));
        includes.map(TagFilter::includeTags).ifPresent(filters::add);
        Optional<List<String>> excludes = this.getGroupsOrTags(this.getPropertiesList(EXCLUDE_GROUPS), this.getPropertiesList(EXCLUDE_TAGS));
        excludes.map(TagFilter::excludeTags).ifPresent(filters::add);
        TestListResolver testListResolver = this.parameters.getTestRequest().getTestListResolver();
        if (!testListResolver.isEmpty()) {
            filters.add(new TestMethodFilter(testListResolver));
        }
        return filters.toArray(new Filter[filters.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getConfigurationParameters() {
        String content = (String)this.parameters.getProviderProperties().get(CONFIGURATION_PARAMETERS);
        if (content == null) {
            return Collections.emptyMap();
        }
        try (StringReader reader = new StringReader(content);){
            HashMap<String, String> result = new HashMap<String, String>();
            Properties props = new Properties();
            props.load(reader);
            props.stringPropertyNames().forEach(key -> result.put((String)key, props.getProperty((String)key)));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Error reading configurationParameters", ex);
        }
    }

    private Optional<List<String>> getPropertiesList(String key) {
        List compoundProperties = null;
        String property = (String)this.parameters.getProviderProperties().get(key);
        if (StringUtils.isNotBlank((String)property)) {
            compoundProperties = Arrays.stream(property.split("[,]+")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        }
        return Optional.ofNullable(compoundProperties);
    }

    private Optional<List<String>> getGroupsOrTags(Optional<List<String>> groups, Optional<List<String>> tags) {
        Optional<List<String>> elements = Optional.empty();
        Preconditions.condition((!groups.isPresent() || !tags.isPresent() ? 1 : 0) != 0, (String)EXCEPTION_MESSAGE_BOTH_NOT_ALLOWED);
        if (groups.isPresent()) {
            elements = groups;
        } else if (tags.isPresent()) {
            elements = tags;
        }
        return elements;
    }
}

