/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.time.Duration;
import java.time.Instant;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.testkit.engine.TerminationInfo;

@API(status=API.Status.MAINTAINED, since="1.7")
public class Execution {
    private final TestDescriptor testDescriptor;
    private final Instant startInstant;
    private final Instant endInstant;
    private final Duration duration;
    private final TerminationInfo terminationInfo;

    public static Execution finished(TestDescriptor testDescriptor, Instant startInstant, Instant endInstant, TestExecutionResult executionResult) {
        return new Execution(testDescriptor, startInstant, endInstant, TerminationInfo.executed(executionResult));
    }

    public static Execution skipped(TestDescriptor testDescriptor, Instant startInstant, Instant endInstant, String skipReason) {
        return new Execution(testDescriptor, startInstant, endInstant, TerminationInfo.skipped(skipReason));
    }

    private Execution(TestDescriptor testDescriptor, Instant startInstant, Instant endInstant, TerminationInfo terminationInfo) {
        Preconditions.notNull((Object)testDescriptor, (String)"TestDescriptor must not be null");
        Preconditions.notNull((Object)startInstant, (String)"Start Instant must not be null");
        Preconditions.notNull((Object)endInstant, (String)"End Instant must not be null");
        Preconditions.notNull((Object)terminationInfo, (String)"TerminationInfo must not be null");
        this.testDescriptor = testDescriptor;
        this.startInstant = startInstant;
        this.endInstant = endInstant;
        this.duration = Duration.between(startInstant, endInstant);
        this.terminationInfo = terminationInfo;
    }

    public TestDescriptor getTestDescriptor() {
        return this.testDescriptor;
    }

    public Instant getStartInstant() {
        return this.startInstant;
    }

    public Instant getEndInstant() {
        return this.endInstant;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public TerminationInfo getTerminationInfo() {
        return this.terminationInfo;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("testDescriptor", (Object)this.testDescriptor).append("startInstant", (Object)this.startInstant).append("endInstant", (Object)this.endInstant).append("duration", (Object)this.duration).append("terminationInfo", (Object)this.terminationInfo).toString();
    }
}

