/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class Binding
extends GroovyObjectSupport
implements Serializable {
    private Map variables;

    public Binding() {
    }

    public Binding(Map variables) {
        this.variables = variables;
    }

    public Binding(String[] args) {
        this();
        this.setVariable("args", args);
    }

    public Object getVariable(String name) {
        if (this.variables == null) {
            throw new MissingPropertyException(name, this.getClass());
        }
        Object result = this.variables.get(name);
        if (result == null && !this.variables.containsKey(name)) {
            throw new MissingPropertyException(name, this.getClass());
        }
        return result;
    }

    public void setVariable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap();
        }
        this.variables.put(name, value);
    }

    public Map getVariables() {
        if (this.variables == null) {
            this.variables = new LinkedHashMap();
        }
        return this.variables;
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return this.getVariable(property);
        }
    }

    public void setProperty(String property, Object newValue) {
        try {
            super.setProperty(property, newValue);
        }
        catch (MissingPropertyException e) {
            this.setVariable(property, newValue);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.variables != null) {
            for (Map.Entry entry : this.variables.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof Serializable)) continue;
                oos.writeObject(entry.getKey());
                oos.writeObject(v);
            }
        }
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object key;
        while ((key = ois.readObject()) != null) {
            if (this.variables == null) {
                this.variables = new LinkedHashMap();
            }
            this.variables.put(key, ois.readObject());
        }
        return;
    }
}

