/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.jnlp;

import hudson.remoting.Engine;
import hudson.remoting.jnlp.GUI;
import hudson.remoting.jnlp.GuiListener;
import hudson.remoting.jnlp.MainMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainDialog
extends JFrame {
    private MainMenu mainMenu;
    private final JLabel statusLabel;

    public MainDialog() throws HeadlessException {
        super("Hudson slave agent");
        ImageIcon background = new ImageIcon(this.getClass().getResource("title.png"));
        JPanel foregroundPanel = new JPanel(new BorderLayout(10, 10));
        foregroundPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        foregroundPanel.setOpaque(false);
        this.statusLabel = new JLabel("", 11);
        foregroundPanel.add((Component)this.statusLabel, "Center");
        this.setContentPane(GUI.wrapInBackgroundImage(foregroundPanel, background, 3, 10));
        this.resetMenuBar();
        this.pack();
        this.setSize(new Dimension(250, 150));
        this.getContentPane().setBackground(Color.WHITE);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(3);
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public void resetMenuBar() {
        this.mainMenu = new MainMenu(this);
        if (this.mainMenu.getComponentCount() > 0) {
            this.setJMenuBar(this.mainMenu);
            this.mainMenu.commit();
        } else {
            this.setJMenuBar(null);
            if (this.isVisible()) {
                this.setVisible(true);
            }
        }
    }

    public void status(String msg) {
        this.statusLabel.setText(msg);
    }

    public static MainDialog get() {
        Engine e = Engine.current();
        if (e == null) {
            return null;
        }
        if (!(e.listener instanceof GuiListener)) {
            return null;
        }
        return ((GuiListener)e.listener).frame;
    }
}

