/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.Immutable;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ImmutableASTTransformation
implements ASTTransformation,
Opcodes {
    private static Class[] immutableList = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class, BigInteger.class, BigDecimal.class, Color.class};
    private static final Class MY_CLASS = Immutable.class;
    private static final ClassNode MY_TYPE = new ClassNode(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode OBJECT_TYPE = new ClassNode(Object.class);
    private static final ClassNode HASHMAP_TYPE = new ClassNode(HashMap.class);
    private static final ClassNode MAP_TYPE = new ClassNode(Map.class);
    private static final ClassNode DATE_TYPE = new ClassNode(Date.class);
    private static final ClassNode CLONEABLE_TYPE = new ClassNode(Cloneable.class);
    private static final ClassNode COLLECTION_TYPE = new ClassNode(Collection.class);
    private static final ClassNode HASHUTIL_TYPE = new ClassNode(HashCodeHelper.class);
    private static final ClassNode STRINGBUFFER_TYPE = new ClassNode(StringBuffer.class);
    private static final ClassNode DGM_TYPE = new ClassNode(DefaultGroovyMethods.class);
    private static final ClassNode SELF_TYPE = new ClassNode(ImmutableASTTransformation.class);
    private static final Token COMPARE_EQUAL = Token.newSymbol(123, -1, -1);
    private static final Token COMPARE_NOT_EQUAL = Token.newSymbol(120, -1, -1);
    private static final Token COMPARE_IDENTICAL = Token.newSymbol(121, -1, -1);
    private static final Token ASSIGN = Token.newSymbol(100, -1, -1);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (!(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        ArrayList<PropertyNode> newNodes = new ArrayList<PropertyNode>();
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            String cName = cNode.getName();
            if (cNode.isInterface()) {
                throw new RuntimeException("Error processing interface '" + cName + "'. " + MY_TYPE_NAME + " not allowed for interfaces.");
            }
            if ((cNode.getModifiers() & 0x10) == 0) {
                throw new RuntimeException("Error processing class '" + cName + "'. " + MY_TYPE_NAME + " classes must be final.");
            }
            List pList = cNode.getProperties();
            for (PropertyNode pNode : pList) {
                this.adjustPropertyForImmutability(pNode, newNodes);
            }
            for (PropertyNode pNode : newNodes) {
                pList.remove(pNode);
                this.addProperty(cNode, pNode);
            }
            List<FieldNode> fList = cNode.getFields();
            for (FieldNode fNode : fList) {
                this.ensureNotPublic(cName, fNode);
            }
            this.createConstructor(cNode);
            this.createHashCode(cNode);
            this.createEquals(cNode);
            this.createToString(cNode);
        }
    }

    private void ensureNotPublic(String cNode, FieldNode fNode) {
        String fName = fNode.getName();
        if (fNode.isPublic() && !fName.contains("$")) {
            throw new RuntimeException("Public field '" + fName + "' not allowed for " + MY_TYPE_NAME + " class '" + cNode + "'.");
        }
    }

    private void createHashCode(ClassNode cNode) {
        FieldNode hashField = cNode.addField("$hash$code", 4098, ClassHelper.int_TYPE, null);
        BlockStatement body = new BlockStatement();
        FieldExpression hash = new FieldExpression(hashField);
        List list = cNode.getProperties();
        body.addStatement(new IfStatement(this.isZeroExpr(hash), this.calculateHashStatements(hash, list), new EmptyStatement()));
        body.addStatement(new ReturnStatement(hash));
        cNode.addMethod(new MethodNode("hashCode", 1, ClassHelper.int_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body));
    }

    private void createToString(ClassNode cNode) {
        BlockStatement body = new BlockStatement();
        List list = cNode.getProperties();
        VariableExpression result = new VariableExpression("_result");
        ConstructorCallExpression init = new ConstructorCallExpression(STRINGBUFFER_TYPE, MethodCallExpression.NO_ARGUMENTS);
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)result, ASSIGN, (Expression)init)));
        body.addStatement(this.append(result, new ConstantExpression(cNode.getName())));
        body.addStatement(this.append(result, new ConstantExpression("(")));
        boolean first = true;
        for (PropertyNode pNode : list) {
            if (first) {
                first = false;
            } else {
                body.addStatement(this.append(result, new ConstantExpression(", ")));
            }
            body.addStatement(new IfStatement(new BooleanExpression(new FieldExpression(cNode.getField("$map$constructor"))), this.toStringPropertyName(result, pNode.getName()), new EmptyStatement()));
            FieldExpression fieldExpr = new FieldExpression(pNode.getField());
            body.addStatement(this.append(result, new MethodCallExpression((Expression)fieldExpr, "toString", MethodCallExpression.NO_ARGUMENTS)));
        }
        body.addStatement(this.append(result, new ConstantExpression(")")));
        body.addStatement(new ReturnStatement(new MethodCallExpression((Expression)result, "toString", MethodCallExpression.NO_ARGUMENTS)));
        cNode.addMethod(new MethodNode("toString", 1, ClassHelper.STRING_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body));
    }

    private Statement toStringPropertyName(Expression result, String fName) {
        BlockStatement body = new BlockStatement();
        body.addStatement(this.append(result, new ConstantExpression(fName)));
        body.addStatement(this.append(result, new ConstantExpression(":")));
        return body;
    }

    private ExpressionStatement append(Expression result, Expression expr) {
        return new ExpressionStatement(new MethodCallExpression(result, "append", expr));
    }

    private Statement calculateHashStatements(Expression hash, List<PropertyNode> list) {
        BlockStatement body = new BlockStatement();
        VariableExpression result = new VariableExpression("_result");
        StaticMethodCallExpression init = new StaticMethodCallExpression(HASHUTIL_TYPE, "initHash", MethodCallExpression.NO_ARGUMENTS);
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)result, ASSIGN, (Expression)init)));
        for (PropertyNode pNode : list) {
            FieldExpression fieldExpr = new FieldExpression(pNode.getField());
            TupleExpression args = new TupleExpression(result, fieldExpr);
            StaticMethodCallExpression current = new StaticMethodCallExpression(HASHUTIL_TYPE, "updateHash", args);
            body.addStatement(this.assignStatement(result, current));
        }
        body.addStatement(this.assignStatement(hash, result));
        return body;
    }

    private void createEquals(ClassNode cNode) {
        BlockStatement body = new BlockStatement();
        VariableExpression other = new VariableExpression("other");
        body.addStatement(this.returnFalseIfNull(other));
        body.addStatement(this.returnFalseIfWrongType(cNode, other));
        body.addStatement(this.returnTrueIfIdentical(VariableExpression.THIS_EXPRESSION, other));
        List list = cNode.getProperties();
        for (PropertyNode pNode : list) {
            body.addStatement(this.returnFalseIfPropertyNotEqual(pNode, other));
        }
        body.addStatement(new ReturnStatement(ConstantExpression.TRUE));
        Parameter[] params = new Parameter[]{new Parameter(OBJECT_TYPE, "other")};
        cNode.addMethod(new MethodNode("equals", 1, ClassHelper.boolean_TYPE, params, ClassNode.EMPTY_ARRAY, body));
    }

    private Statement returnFalseIfWrongType(ClassNode cNode, Expression other) {
        return new IfStatement(this.identicalExpr(new ClassExpression(cNode), new ClassExpression(other.getType())), new ReturnStatement(ConstantExpression.FALSE), new EmptyStatement());
    }

    private IfStatement returnFalseIfNull(Expression other) {
        return new IfStatement(this.equalsNullExpr(other), new ReturnStatement(ConstantExpression.FALSE), new EmptyStatement());
    }

    private IfStatement returnTrueIfIdentical(Expression self, Expression other) {
        return new IfStatement(this.identicalExpr(self, other), new ReturnStatement(ConstantExpression.TRUE), new EmptyStatement());
    }

    private Statement returnFalseIfPropertyNotEqual(PropertyNode pNode, Expression other) {
        return new IfStatement(this.notEqualsExpr(pNode, other), new ReturnStatement(ConstantExpression.FALSE), new EmptyStatement());
    }

    private void addProperty(ClassNode cNode, PropertyNode pNode) {
        FieldNode fn = pNode.getField();
        cNode.getFields().remove(fn);
        cNode.addProperty(pNode.getName(), pNode.getModifiers() | 0x10, pNode.getType(), pNode.getInitialExpression(), pNode.getGetterBlock(), pNode.getSetterBlock());
        FieldNode newfn = cNode.getField(fn.getName());
        cNode.getFields().remove(newfn);
        cNode.addField(fn);
    }

    private void createConstructor(ClassNode cNode) {
        boolean specialHashMapCase;
        FieldNode constructorField = cNode.addField("$map$constructor", 4098, ClassHelper.boolean_TYPE, null);
        FieldExpression constructorStyle = new FieldExpression(constructorField);
        if (cNode.getDeclaredConstructors().size() != 0) {
            throw new RuntimeException("Explicit constructors not allowed for " + MY_TYPE_NAME + " class: " + cNode.getNameWithoutPackage());
        }
        List list = cNode.getProperties();
        boolean bl = specialHashMapCase = list.size() == 1 && ((PropertyNode)list.get(0)).getField().getType().equals(HASHMAP_TYPE);
        if (specialHashMapCase) {
            this.createConstructorMapSpecial(cNode, constructorStyle, list);
        } else {
            this.createConstructorMap(cNode, constructorStyle, list);
            this.createConstructorOrdered(cNode, constructorStyle, list);
        }
    }

    private void createConstructorMapSpecial(ClassNode cNode, FieldExpression constructorStyle, List<PropertyNode> list) {
        BlockStatement body = new BlockStatement();
        body.addStatement(this.createConstructorStatementMapSpecial(list.get(0).getField()));
        this.createConstructorMapCommon(cNode, constructorStyle, body);
    }

    private void createConstructorMap(ClassNode cNode, FieldExpression constructorStyle, List<PropertyNode> list) {
        BlockStatement body = new BlockStatement();
        for (PropertyNode pNode : list) {
            body.addStatement(this.createConstructorStatement(cNode, pNode));
        }
        this.createConstructorMapCommon(cNode, constructorStyle, body);
    }

    private void createConstructorMapCommon(ClassNode cNode, FieldExpression constructorStyle, BlockStatement body) {
        List<FieldNode> fList = cNode.getFields();
        for (FieldNode fNode : fList) {
            if (fNode.isPublic() || fNode.getName().contains("$") || cNode.getProperty(fNode.getName()) != null) continue;
            body.addStatement(this.createConstructorStatementDefault(fNode));
        }
        body.addStatement(this.assignStatement(constructorStyle, ConstantExpression.TRUE));
        Parameter[] params = new Parameter[]{new Parameter(HASHMAP_TYPE, "args")};
        cNode.addConstructor(new ConstructorNode(1, params, ClassNode.EMPTY_ARRAY, new IfStatement(this.equalsNullExpr(new VariableExpression("args")), new EmptyStatement(), body)));
    }

    private void createConstructorOrdered(ClassNode cNode, FieldExpression constructorStyle, List<PropertyNode> list) {
        MapExpression argMap = new MapExpression();
        Parameter[] orderedParams = new Parameter[list.size()];
        int index = 0;
        for (PropertyNode pNode : list) {
            orderedParams[index++] = new Parameter(pNode.getField().getType(), pNode.getField().getName());
            argMap.addMapEntryExpression(new ConstantExpression(pNode.getName()), new VariableExpression(pNode.getName()));
        }
        BlockStatement orderedBody = new BlockStatement();
        orderedBody.addStatement(new ExpressionStatement(new ConstructorCallExpression(ClassNode.THIS, new ArgumentListExpression(new CastExpression(HASHMAP_TYPE, argMap)))));
        orderedBody.addStatement(this.assignStatement(constructorStyle, ConstantExpression.FALSE));
        cNode.addConstructor(new ConstructorNode(1, orderedParams, ClassNode.EMPTY_ARRAY, orderedBody));
    }

    private Statement createConstructorStatement(ClassNode cNode, PropertyNode pNode) {
        Statement statement;
        FieldNode fNode = pNode.getField();
        ClassNode fieldType = fNode.getType();
        if (fieldType.isArray() || this.implementsInterface(fieldType, CLONEABLE_TYPE)) {
            statement = this.createConstructorStatementArrayOrCloneable(fNode);
        } else if (fieldType.isDerivedFrom(DATE_TYPE)) {
            statement = this.createConstructorStatementDate(fNode);
        } else if (fieldType.isDerivedFrom(COLLECTION_TYPE) || fieldType.isDerivedFrom(MAP_TYPE)) {
            statement = this.createConstructorStatementCollection(fNode);
        } else if (this.isKnownImmutable(fieldType)) {
            statement = this.createConstructorStatementDefault(fNode);
        } else {
            if (fieldType.isResolved()) {
                throw new RuntimeException(ImmutableASTTransformation.createErrorMessage(cNode.getName(), fNode.getName(), fieldType.getName(), "compiling"));
            }
            statement = this.createConstructorStatementGuarded(cNode, fNode);
        }
        return statement;
    }

    private boolean implementsInterface(ClassNode fieldType, ClassNode interfaceType) {
        return Arrays.asList(fieldType.getInterfaces()).contains(interfaceType);
    }

    private Statement createConstructorStatementGuarded(ClassNode cNode, FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression unknown = this.findArg(fNode.getName());
        return new IfStatement(this.equalsNullExpr(unknown), new IfStatement(this.equalsNullExpr(initExpr), new EmptyStatement(), this.assignStatement(fieldExpr, this.checkUnresolved(cNode, fNode, initExpr))), this.assignStatement(fieldExpr, this.checkUnresolved(cNode, fNode, unknown)));
    }

    private Expression checkUnresolved(ClassNode cNode, FieldNode fNode, Expression value) {
        TupleExpression args = new TupleExpression(new ConstantExpression(cNode.getName()), new ConstantExpression(fNode.getName()), value);
        return new StaticMethodCallExpression(SELF_TYPE, "checkImmutable", args);
    }

    private Statement createConstructorStatementCollection(FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression collection = this.findArg(fNode.getName());
        return new IfStatement(this.equalsNullExpr(collection), new IfStatement(this.equalsNullExpr(initExpr), new EmptyStatement(), this.assignStatement(fieldExpr, this.cloneCollectionExpr(initExpr))), this.assignStatement(fieldExpr, this.cloneCollectionExpr(collection)));
    }

    private Statement createConstructorStatementMapSpecial(FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression namedArgs = this.findArg(fNode.getName());
        VariableExpression baseArgs = new VariableExpression("args");
        return new IfStatement(this.equalsNullExpr(baseArgs), new IfStatement(this.equalsNullExpr(initExpr), new EmptyStatement(), this.assignStatement(fieldExpr, this.cloneCollectionExpr(initExpr))), new IfStatement(this.equalsNullExpr(namedArgs), new IfStatement(this.isTrueExpr(new MethodCallExpression((Expression)baseArgs, "containsKey", (Expression)new ConstantExpression(fNode.getName()))), this.assignStatement(fieldExpr, namedArgs), this.assignStatement(fieldExpr, this.cloneCollectionExpr(baseArgs))), new IfStatement(this.isOneExpr(new MethodCallExpression((Expression)baseArgs, "size", MethodCallExpression.NO_ARGUMENTS)), this.assignStatement(fieldExpr, this.cloneCollectionExpr(namedArgs)), this.assignStatement(fieldExpr, this.cloneCollectionExpr(baseArgs)))));
    }

    private boolean isKnownImmutable(ClassNode fieldType) {
        if (!fieldType.isResolved()) {
            return false;
        }
        Class typeClass = fieldType.getTypeClass();
        return typeClass.isEnum() || typeClass.isPrimitive() || ImmutableASTTransformation.inImmutableList(typeClass);
    }

    private static boolean inImmutableList(Class typeClass) {
        return Arrays.asList(immutableList).contains(typeClass);
    }

    private Statement createConstructorStatementDefault(FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression value = this.findArg(fNode.getName());
        return new IfStatement(this.equalsNullExpr(value), new IfStatement(this.equalsNullExpr(initExpr), new EmptyStatement(), this.assignStatement(fieldExpr, initExpr)), this.assignStatement(fieldExpr, value));
    }

    private Statement createConstructorStatementArrayOrCloneable(FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression array = this.findArg(fNode.getName());
        return new IfStatement(this.equalsNullExpr(array), new IfStatement(this.equalsNullExpr(initExpr), this.assignStatement(fieldExpr, ConstantExpression.NULL), this.assignStatement(fieldExpr, this.cloneArrayOrCloneableExpr(initExpr))), this.assignStatement(fieldExpr, this.cloneArrayOrCloneableExpr(array)));
    }

    private Statement createConstructorStatementDate(FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression date = this.findArg(fNode.getName());
        return new IfStatement(this.equalsNullExpr(date), new IfStatement(this.equalsNullExpr(initExpr), this.assignStatement(fieldExpr, ConstantExpression.NULL), this.assignStatement(fieldExpr, this.cloneDateExpr(initExpr))), this.assignStatement(fieldExpr, this.cloneDateExpr(date)));
    }

    private Expression cloneDateExpr(Expression origDate) {
        return new ConstructorCallExpression(DATE_TYPE, new MethodCallExpression(origDate, "getTime", MethodCallExpression.NO_ARGUMENTS));
    }

    private Statement assignStatement(Expression fieldExpr, Expression value) {
        return new ExpressionStatement(this.assignExpr(fieldExpr, value));
    }

    private Expression assignExpr(Expression fieldExpr, Expression value) {
        return new BinaryExpression(fieldExpr, ASSIGN, value);
    }

    private BooleanExpression equalsNullExpr(Expression argExpr) {
        return new BooleanExpression(new BinaryExpression(argExpr, COMPARE_EQUAL, ConstantExpression.NULL));
    }

    private BooleanExpression isTrueExpr(Expression argExpr) {
        return new BooleanExpression(new BinaryExpression(argExpr, COMPARE_EQUAL, ConstantExpression.TRUE));
    }

    private BooleanExpression isZeroExpr(Expression expr) {
        return new BooleanExpression(new BinaryExpression(expr, COMPARE_EQUAL, new ConstantExpression(0)));
    }

    private BooleanExpression isOneExpr(Expression expr) {
        return new BooleanExpression(new BinaryExpression(expr, COMPARE_EQUAL, new ConstantExpression(1)));
    }

    private BooleanExpression notEqualsExpr(PropertyNode pNode, Expression other) {
        FieldExpression fieldExpr = new FieldExpression(pNode.getField());
        PropertyExpression otherExpr = new PropertyExpression(other, pNode.getField().getName());
        return new BooleanExpression(new BinaryExpression(fieldExpr, COMPARE_NOT_EQUAL, otherExpr));
    }

    private BooleanExpression identicalExpr(Expression self, Expression other) {
        return new BooleanExpression(new BinaryExpression(self, COMPARE_IDENTICAL, other));
    }

    private Expression findArg(String fName) {
        return new PropertyExpression((Expression)new VariableExpression("args"), fName);
    }

    private void adjustPropertyForImmutability(PropertyNode pNode, List<PropertyNode> newNodes) {
        FieldNode fNode = pNode.getField();
        fNode.setModifiers(pNode.getModifiers() & 0xFFFFFFFE | 0x10 | 2);
        this.adjustPropertyNode(pNode, this.createGetterBody(fNode));
        newNodes.add(pNode);
    }

    private void adjustPropertyNode(PropertyNode pNode, Statement getterBody) {
        pNode.setSetterBlock(null);
        pNode.setGetterBlock(getterBody);
    }

    private Statement createGetterBody(FieldNode fNode) {
        BlockStatement body = new BlockStatement();
        ClassNode fieldType = fNode.getType();
        Statement statement = fieldType.isArray() || this.implementsInterface(fieldType, CLONEABLE_TYPE) ? this.createGetterBodyArrayOrCloneable(fNode) : (fieldType.isDerivedFrom(DATE_TYPE) ? this.createGetterBodyDate(fNode) : this.createGetterBodyDefault(fNode));
        body.addStatement(statement);
        return body;
    }

    private Statement createGetterBodyDefault(FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        return new ExpressionStatement(fieldExpr);
    }

    private static String createErrorMessage(String className, String fieldName, String typeName, String mode) {
        return MY_TYPE_NAME + " processor doesn't know how to handle field '" + fieldName + "' of type '" + ImmutableASTTransformation.prettyTypeName(typeName) + "' while " + mode + " class " + className + ".\n" + MY_TYPE_NAME + " classes currently only support properties with known immutable types " + "or types where special handling achieves immutable behavior, including:\n" + "- Strings, primitive types, wrapper types, BigInteger and BigDecimal\n" + "- enums, other " + MY_TYPE_NAME + " classes and known immutables (java.awt.Color)\n" + "- Cloneable classes, collections, maps and arrays, and other classes with special handling (java.util.Date)\n" + "Other restrictions apply, please see the groovydoc for " + MY_TYPE_NAME + " for further details";
    }

    private static String prettyTypeName(String name) {
        return name.equals("java.lang.Object") ? name + " or def" : name;
    }

    private Statement createGetterBodyArrayOrCloneable(FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        Expression expression = this.cloneArrayOrCloneableExpr(fieldExpr);
        return this.safeExpression(fieldExpr, expression);
    }

    private Expression cloneArrayOrCloneableExpr(Expression fieldExpr) {
        return new MethodCallExpression(fieldExpr, "clone", MethodCallExpression.NO_ARGUMENTS);
    }

    private Expression cloneCollectionExpr(Expression fieldExpr) {
        return new StaticMethodCallExpression(DGM_TYPE, "asImmutable", fieldExpr);
    }

    private Statement createGetterBodyDate(FieldNode fNode) {
        FieldExpression fieldExpr = new FieldExpression(fNode);
        Expression expression = this.cloneDateExpr(fieldExpr);
        return this.safeExpression(fieldExpr, expression);
    }

    private Statement safeExpression(Expression fieldExpr, Expression expression) {
        return new IfStatement(this.equalsNullExpr(fieldExpr), new ExpressionStatement(fieldExpr), new ExpressionStatement(expression));
    }

    public static Object checkImmutable(String className, String fieldName, Object field) {
        if (field == null || field instanceof Enum || ImmutableASTTransformation.inImmutableList(field.getClass())) {
            return field;
        }
        if (field instanceof Collection) {
            return DefaultGroovyMethods.asImmutable((Collection)field);
        }
        if (field.getClass().getAnnotation(MY_CLASS) != null) {
            return field;
        }
        String typeName = field.getClass().getName();
        throw new RuntimeException(ImmutableASTTransformation.createErrorMessage(className, fieldName, typeName, "constructing"));
    }
}

