/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.jaxb;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.util.DOMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeInsertPlugin
extends AbstractParameterizablePlugin {
    public static final String NS = "http://hudson-ci.org/jaxb/hudson/code-insert";
    public static final String CODE = "code";
    public static final String IMPORT = "import";

    public String getOptionName() {
        return "XcodeInsert";
    }

    public String getUsage() {
        return "Allows arbitrary code to be inserted into generated types.";
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(new QName(NS, CODE), new QName(NS, IMPORT));
    }

    protected boolean run(Outline outline, Options options) throws Exception {
        assert (outline != null);
        assert (options != null);
        for (ClassOutline type : outline.getClasses()) {
            this.process(type.implClass, type.target.getCustomizations(), type.parent());
        }
        for (ClassOutline type : outline.getEnums()) {
            this.process(type.clazz, type.target.getCustomizations(), type.parent());
        }
        return true;
    }

    private void process(JDefinedClass type, CCustomizations customizations, Outline parent) {
        this.processImport(type, customizations, parent);
        this.processCode(type, customizations, parent);
    }

    private void processImport(JDefinedClass type, CCustomizations customizations, Outline parent) {
        assert (type != null);
        assert (customizations != null);
        assert (parent != null);
        CPluginCustomization custom = customizations.find(NS, IMPORT);
        if (custom != null) {
            custom.markAsAcknowledged();
            String body = DOMUtils.getElementText((Element)custom.element);
            String[] tmp = body.trim().split("\\s+");
            ArrayList<String> names = new ArrayList<String>();
            for (String name : tmp) {
                if (name.trim().length() == 0) continue;
                names.add(name);
            }
            if (!names.isEmpty()) {
                JBlock block = type.init()._if(JExpr.direct((String)"false"))._then();
                for (String name : names) {
                    JClass ref = parent.getCodeModel().ref(name);
                    block.invoke(ref.dotclass(), "toString");
                }
            }
        }
    }

    private void processCode(JDefinedClass type, CCustomizations customizations, Outline parent) {
        assert (type != null);
        assert (customizations != null);
        assert (parent != null);
        CPluginCustomization custom = customizations.find(NS, CODE);
        if (custom != null) {
            custom.markAsAcknowledged();
            String body = DOMUtils.getElementText((Element)custom.element);
            type.direct(body);
        }
    }
}

