/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.favorite.FavoritePlugin;
import hudson.plugins.favorite.listener.FavoriteListener;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import jenkins.model.Jenkins;

public final class Favorites {
    public static boolean toggleFavorite(@NonNull User user, @NonNull Item item) throws FavoriteException {
        try {
            FavoriteUserProperty property = Favorites.getProperty(user);
            return property.toggleFavorite(item.getFullName());
        }
        catch (IOException e) {
            throw new FavoriteException("Could not determine Favorite state. User: <" + user.getFullName() + "> Item: <" + item.getFullName() + ">", e);
        }
    }

    public static boolean isFavorite(@NonNull User user, @NonNull Item item) {
        FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
        return fup != null && fup.isJobFavorite(item.getFullName());
    }

    public static boolean hasFavorite(@NonNull User user, @NonNull Item item) throws FavoriteException {
        try {
            FavoriteUserProperty property = Favorites.getProperty(user);
            return property.hasFavorite(item.getFullName());
        }
        catch (IOException e) {
            throw new FavoriteException("Could not determine Favorite state. User: <" + user.getFullName() + "> Item: <" + item.getFullName() + ">", e);
        }
    }

    public static void addFavorite(@NonNull User user, @NonNull Item item) throws FavoriteException {
        try {
            if (Favorites.isFavorite(user, item)) {
                throw new FavoriteException("Favourite is already set for User: <" + user.getFullName() + "> Item: <" + item.getFullName() + ">");
            }
            FavoriteUserProperty property = Favorites.getProperty(user);
            property.addFavorite(item.getFullName());
            FavoriteListener.fireOnAddFavourite(item, user);
        }
        catch (IOException e) {
            throw new FavoriteException("Could not add Favorite. User: <" + user.getFullName() + "> Item: <" + item.getFullName() + ">", e);
        }
    }

    public static void removeFavorite(@NonNull User user, @NonNull Item item) throws FavoriteException {
        try {
            if (!Favorites.isFavorite(user, item)) {
                throw new FavoriteException("Favourite is already unset for User: <" + user.getFullName() + "> Item: <" + item.getFullName() + ">");
            }
            FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
            fup.removeFavorite(item.getFullName());
            FavoriteListener.fireOnRemoveFavourite(item, user);
        }
        catch (IOException e) {
            throw new FavoriteException("Could not remove Favorite. User: <" + user.getFullName() + "> Item: <" + item.getFullName() + ">", e);
        }
    }

    public static Iterable<Item> getFavorites(@NonNull User user) {
        FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
        if (fup == null) {
            return Collections.emptyList();
        }
        Set<String> favorites = fup.getAllFavorites();
        if (favorites.isEmpty()) {
            return Collections.emptyList();
        }
        final Iterator<String> iterator = favorites.iterator();
        final Jenkins jenkins = Jenkins.get();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        return () -> Iterators.filter((Iterator)new Iterator<Item>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Item next() {
                return jenkins.getItemByFullName((String)iterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }, (Predicate)Predicates.notNull());
    }

    private static FavoriteUserProperty getProperty(@NonNull User user) throws IOException {
        if (FavoritePlugin.isAnonymous(user)) {
            throw new IllegalArgumentException("user cannot be anonymous");
        }
        FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
        if (fup == null) {
            user.addProperty((UserProperty)new FavoriteUserProperty());
            fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
        }
        return fup;
    }

    public static class FavoriteException
    extends Exception {
        public FavoriteException(String message, Throwable cause) {
            super(message, cause);
        }

        public FavoriteException(String message) {
            super(message);
        }
    }
}

