/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.column;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.favorite.Messages;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import hudson.views.ListViewColumn;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class FavoriteColumn
extends ListViewColumn {
    @Extension
    public static final Descriptor<ListViewColumn> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public FavoriteColumn() {
    }

    public Descriptor<ListViewColumn> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getStarClassName(String job) {
        FavoriteUserProperty fup = this.getFavoriteUserProperty();
        if (fup == null || !fup.isJobFavorite(job)) {
            return "icon-fav-inactive";
        }
        return "icon-fav-active";
    }

    public String getSizeClassFromIconSize(String iconSize) {
        if ("16x16".equals(iconSize)) {
            return "icon-sm";
        }
        if ("24x24".equals(iconSize)) {
            return "icon-md";
        }
        if ("32x32".equals(iconSize)) {
            return "icon-lg";
        }
        if ("48x48".equals(iconSize)) {
            return "icon-xlg";
        }
        return "icon-md";
    }

    private FavoriteUserProperty getFavoriteUserProperty() {
        Authentication authentication = Hudson.getAuthentication();
        String name = authentication.getName();
        Jenkins jenkins = Jenkins.get();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        User user = jenkins.getUser(name);
        if (user == null) {
            throw new IllegalStateException("Can't find user " + name);
        }
        return (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
    }

    public int getSortData(String job) {
        FavoriteUserProperty fup = this.getFavoriteUserProperty();
        if (fup == null || !fup.isJobFavorite(job)) {
            return 0;
        }
        return 1;
    }

    public String getUserId() {
        Authentication authentication = Hudson.getAuthentication();
        return authentication.getName();
    }

    public boolean isLoggedIn() {
        Authentication authentication = Hudson.getAuthentication();
        return !StringUtils.equals((String)authentication.getName(), (String)"anonymous");
    }

    private static class DescriptorImpl
    extends Descriptor<ListViewColumn> {
        private DescriptorImpl() {
        }

        public ListViewColumn newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new FavoriteColumn();
        }

        public String getDisplayName() {
            return Messages.favoriteColumn();
        }
    }
}

