/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.filter;

import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.View;
import hudson.plugins.favorite.Favorites;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;

public class FavoriteFilter
extends ViewJobFilter {
    @DataBoundConstructor
    public FavoriteFilter() {
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ArrayList<TopLevelItem> filtered = new ArrayList<TopLevelItem>();
        Authentication authentication = Hudson.getAuthentication();
        String name = authentication.getName();
        if (name != null && authentication.isAuthenticated()) {
            Jenkins jenkins = Jenkins.get();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins not started");
            }
            User user = jenkins.getUser(name);
            if (user != null) {
                for (TopLevelItem item : added) {
                    if (!Favorites.isFavorite(user, (Item)item)) continue;
                    filtered.add(item);
                }
            }
        }
        return filtered;
    }
}

