/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.project;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import hudson.plugins.favorite.Messages;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public class FavoriteProjectAction
implements Action {
    private final AbstractProject<?, ?> project;

    public FavoriteProjectAction(AbstractProject project) {
        this.project = project;
    }

    public String getProjectName() {
        return this.project.getFullName();
    }

    public String getIconFileName() {
        if (this.hasPermission() && this.isSupportedJobType()) {
            return this.isFavorite() ? "star-large-gold.svg" : "star-large.svg";
        }
        return null;
    }

    public String getDisplayName() {
        if (this.hasPermission() && this.isSupportedJobType()) {
            return Messages.favoriteColumn();
        }
        return null;
    }

    public String getUrlName() {
        if (this.hasPermission() && this.isSupportedJobType()) {
            try {
                Jenkins jenkins = Jenkins.get();
                if (jenkins == null) {
                    throw new IllegalStateException("Jenkins not started");
                }
                return "plugin/favorite/toggleFavorite?job=" + URLEncoder.encode(this.getProjectName(), "UTF-8") + "&userName=" + URLEncoder.encode(this.getUserName(), "UTF-8") + "&redirect=true";
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    private boolean hasPermission() {
        Authentication authentication = Hudson.getAuthentication();
        String userName = authentication.getName();
        return !userName.equals("anonymous");
    }

    private boolean isSupportedJobType() {
        return !(this.project instanceof MatrixConfiguration);
    }

    private String getUserName() {
        this.getJenkins();
        Authentication authentication = Jenkins.getAuthentication();
        return authentication.getName();
    }

    private boolean isFavorite() {
        Authentication authentication = Hudson.getAuthentication();
        String userName = authentication.getName();
        if (!userName.equals("anonymous")) {
            User user = this.getJenkins().getUser(userName);
            return user != null && Favorites.isFavorite(user, this.project);
        }
        return false;
    }

    @NonNull
    Jenkins getJenkins() {
        Jenkins jenkins = Jenkins.get();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        return jenkins;
    }
}

