/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.token;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import hudson.tasks.Mailer;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;

@Extension
public class FavoriteUsersEmailTokenMacro
extends DataBoundTokenMacro {
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) {
        return this.evaluate((Run<?, ?>)context, context.getWorkspace(), listener, macroName);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) {
        ArrayList<String> users = new ArrayList<String>();
        Job project = run.getParent();
        for (User user : User.getAll()) {
            if (!Favorites.isFavorite(user, (Item)project)) continue;
            Mailer.UserProperty mail = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
            users.add(mail.getAddress());
        }
        return StringUtils.join(users, (String)",");
    }

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("FAVORITE_USERS_EMAIL");
    }
}

