/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.user;

import com.google.common.collect.Maps;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.favorite.user.FavoriteUserPropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class FavoriteUserProperty
extends UserProperty {
    private static final Logger LOGGER = Logger.getLogger(FavoriteUserProperty.class.getName());
    @Extension
    public static final UserPropertyDescriptor DESCRIPTOR = new FavoriteUserPropertyDescriptor();
    transient List<String> favorites = new ArrayList<String>();
    private ConcurrentMap<String, Boolean> data = new ConcurrentHashMap<String, Boolean>();
    private transient long lastValidated = 0L;

    @DataBoundConstructor
    public FavoriteUserProperty() {
    }

    @Deprecated
    public List<String> getFavorites() {
        this.removeFavoritesWhichDoNotExist();
        return Collections.unmodifiableList(this.data.entrySet().stream().filter(input -> input != null && (Boolean)input.getValue() != false).map(stringBooleanEntry -> (String)stringBooleanEntry.getKey()).collect(Collectors.toList()));
    }

    public Set<String> getAllFavorites() {
        this.removeFavoritesWhichDoNotExist();
        return Maps.filterEntries(this.data, input -> input != null && (Boolean)input.getValue() != false).keySet();
    }

    public void addFavorite(String job) throws IOException {
        this.data.put(job, true);
        this.user.save();
    }

    public void removeFavorite(String job) throws IOException {
        this.data.put(job, false);
        this.user.save();
    }

    public boolean toggleFavorite(String job) throws IOException {
        if (this.isJobFavorite(job)) {
            this.removeFavorite(job);
            return false;
        }
        this.addFavorite(job);
        return true;
    }

    void deleteFavourite(String job) throws IOException {
        this.data.remove(job);
        this.user.save();
    }

    public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return this;
    }

    public boolean isJobFavorite(String job) {
        Boolean favorite = (Boolean)this.data.get(job);
        return favorite != null ? favorite : false;
    }

    public boolean hasFavorite(String job) {
        return this.data.containsKey(job);
    }

    public UserPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    Object readResolve() {
        if (this.favorites != null) {
            this.data = new ConcurrentHashMap<String, Boolean>();
            for (String job : this.favorites) {
                this.data.put(job, true);
            }
            this.favorites = null;
        }
        return this;
    }

    private void removeFavoritesWhichDoNotExist() {
        Jenkins jenkins = Jenkins.get();
        for (String fullName : Collections.unmodifiableSet(this.data.keySet())) {
            if (jenkins.getItemByFullName(fullName) != null) continue;
            try {
                this.deleteFavourite(fullName);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not purge favorite '" + fullName + "'", e);
            }
        }
    }
}

