/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import com.thoughtworks.xstream.XStream;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.findbugs.FindBugsDescriptor;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.parser.Bug;

public class FindBugsResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;
    private static final int LESS_ONE_WEEK = 6;
    private int newThisWeek;
    private int notInCloud;
    private int numberOfComments;

    public FindBugsResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference) {
        this(build, defaultEncoding, result, usePreviousBuildAsReference, useStableBuildAsReference, FindBugsResultAction.class);
    }

    protected FindBugsResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, Class<? extends ResultAction<FindBugsResult>> actionType) {
        this(build, new BuildHistory(build, actionType, usePreviousBuildAsReference, useStableBuildAsReference), result, defaultEncoding, true);
    }

    FindBugsResult(AbstractBuild<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding, boolean canSerialize) {
        super(build, history, result, defaultEncoding);
        this.init();
        if (canSerialize) {
            this.serializeAnnotations(result.getAnnotations());
        }
    }

    private void init() {
        for (FileAnnotation annotation : this.getAnnotations()) {
            if (!(annotation instanceof Bug)) continue;
            Bug bug = (Bug)annotation;
            if (bug.isInCloud()) {
                if (bug.isShouldBeInCloud() && bug.getAgeInDays() <= 6) {
                    ++this.newThisWeek;
                }
                this.numberOfComments += bug.getReviewCount();
                continue;
            }
            if (!bug.isShouldBeInCloud()) continue;
            ++this.notInCloud;
        }
    }

    public int getNumberOfComments() {
        return this.numberOfComments;
    }

    protected void configure(XStream xstream) {
        xstream.alias("bug", Bug.class);
    }

    public String getSummary() {
        return "FindBugs: " + FindBugsResult.createDefaultSummary((String)FindBugsDescriptor.RESULT_URL, (int)this.getNumberOfAnnotations(), (int)this.getNumberOfModules());
    }

    protected String createDeltaMessage() {
        return FindBugsResult.createDefaultDeltaMessage((String)FindBugsDescriptor.RESULT_URL, (int)this.getNumberOfNewWarnings(), (int)this.getNumberOfFixedWarnings());
    }

    public int getNewThisWeek() {
        return this.newThisWeek;
    }

    public int getNotInCloud() {
        return this.notInCloud;
    }

    protected String getSerializationFileName() {
        return "findbugs-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.FindBugs_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return FindBugsResultAction.class;
    }
}

