/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.jvnet.hudson.plugins.JythonPlugin;
import org.jvnet.hudson.plugins.JythonPluginException;
import org.jvnet.hudson.plugins.PythonPackage;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jython
extends Builder {
    private final String command;

    private Jython(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ProxyConfiguration proxy;
        Node builtOn = build.getBuiltOn();
        JDK configuredJdk = build.getProject().getJDK();
        String javaCmd = configuredJdk != null ? configuredJdk.forNode(builtOn, (TaskListener)listener).getHome() + "/bin/java" : "java";
        FilePath jythonHome = builtOn.getRootPath().child("tools/jython");
        String jythonJar = jythonHome.child("jython.jar").getRemote();
        FilePath jythonSitePackages = jythonHome.child("Lib/site-packages");
        FilePath jythonSitePackagesMaster = JythonPlugin.JYTHON_HOME.child("Lib/site-packages");
        Date lastModified = this.getDescriptor().getLastModified();
        if (!jythonSitePackages.equals((Object)jythonSitePackagesMaster) && lastModified != null && this.getDescriptor().getLastModified().after(new Date(jythonSitePackages.lastModified()))) {
            JythonPlugin.syncSitePackages(jythonHome, (TaskListener)listener);
            jythonSitePackages.touch(System.currentTimeMillis());
        }
        FilePath jythonScript = jythonHome.child("tmp").createTextTempFile("script", ".py", this.getCommand());
        HashMap<String, String> envVar = new HashMap<String, String>((Map<String, String>)build.getEnvironment((TaskListener)listener));
        envVar.putAll(build.getBuildVariables());
        if (!envVar.containsKey("http_proxy") && (proxy = Hudson.getInstance().proxy) != null) {
            envVar.put("http_proxy", "http://" + proxy.name + ":" + proxy.port);
        }
        String DEFAULT_JAVA_XMX = "-Xmx512m";
        String javaOpts = (String)envVar.get("JAVA_OPTS");
        if (javaOpts == null) {
            javaOpts = "-Xmx512m";
        } else if (javaOpts.indexOf("-Xmx") == -1) {
            javaOpts = javaOpts + " -Xmx512m";
        }
        ArgumentListBuilder argBuilder = new ArgumentListBuilder(new String[]{javaCmd});
        argBuilder.addTokenized(javaOpts);
        argBuilder.add("-jar");
        argBuilder.add(jythonJar);
        argBuilder.add(jythonScript.getRemote());
        boolean success = 0 == launcher.launch().cmds(argBuilder).envs(envVar).stdout((TaskListener)listener).pwd(build.getWorkspace()).join();
        jythonScript.delete();
        build.setResult(success ? Result.SUCCESS : Result.FAILURE);
        return success;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        private boolean syntaxHighlightingEnabled = true;
        private boolean tabKeyToIndentEnabled = true;
        private int numSpacesPerIndentation = 4;
        private transient Set<PythonPackage> pythonPackages;
        private Date lastModified;

        public DescriptorImpl() {
            super(Jython.class);
            this.load();
        }

        public boolean isSyntaxHighlightingEnabled() {
            return this.syntaxHighlightingEnabled;
        }

        public boolean isTabKeyToIndentEnabled() {
            return this.tabKeyToIndentEnabled;
        }

        public int getNumSpacesPerIndentation() {
            return this.numSpacesPerIndentation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getPackageName(FilePath pkgInfo) {
            String name = null;
            String NAME_PREFIX = "Name: ";
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(pkgInfo.read()));
                    do {
                        if (!(line = reader.readLine()).startsWith("Name: ")) continue;
                        name = line.substring("Name: ".length());
                        break;
                    } while (line != null);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                throw new JythonPluginException("error while determining package name", e);
            }
            if (name == null) {
                throw new JythonPluginException("unable to determine package name");
            }
            return name;
        }

        public Set<PythonPackage> getPythonPackages() {
            return this.pythonPackages;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        private Set<PythonPackage> scanPackages() {
            try {
                HashSet<PythonPackage> pkgs = new HashSet<PythonPackage>();
                List pkgFiles = JythonPlugin.JYTHON_HOME.child("Lib/site-packages").list((FileFilter)new SuffixFileFilter(".egg"));
                for (FilePath pkgFile : pkgFiles) {
                    pkgs.add(new PythonPackage(this.getPackageName(pkgFile.child("EGG-INFO/PKG-INFO"))));
                }
                pkgFiles = JythonPlugin.JYTHON_HOME.child("Lib/site-packages").list((FileFilter)new SuffixFileFilter(".egg-info"));
                for (FilePath pkgFile : pkgFiles) {
                    if (pkgFile.isDirectory()) {
                        pkgs.add(new PythonPackage(this.getPackageName(pkgFile.child("PKG-INFO"))));
                        continue;
                    }
                    pkgs.add(new PythonPackage(this.getPackageName(pkgFile)));
                }
                pkgs.removeAll(PythonPackage.PREINSTALLED_PACKAGES);
                return pkgs;
            }
            catch (IOException e) {
                throw new JythonPluginException("error determining installed packages", e);
            }
            catch (InterruptedException e) {
                throw new JythonPluginException("error determining installed packages", e);
            }
        }

        public void load() {
            super.load();
            this.pythonPackages = this.scanPackages();
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) {
            return new Jython(formData.getString("jython"));
        }

        public String getDisplayName() {
            return "Execute Jython script";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.syntaxHighlightingEnabled = req.getParameter("syntaxHighlightingEnabled") != null;
            this.tabKeyToIndentEnabled = req.getParameter("tabKeyToIndentEnabled") != null;
            this.numSpacesPerIndentation = Integer.parseInt(req.getParameter("numSpacesPerIndentation"));
            List newPythonPackages = req.bindParametersToList(PythonPackage.class, "pythonPackage.");
            boolean packageListModified = false;
            for (PythonPackage pkg : newPythonPackages) {
                if (this.pythonPackages.contains(pkg)) continue;
                pkg.install();
                packageListModified = true;
            }
            for (PythonPackage pkg : this.pythonPackages) {
                if (newPythonPackages.contains(pkg)) continue;
                pkg.uninstall();
                packageListModified = true;
            }
            if (packageListModified) {
                this.pythonPackages = this.scanPackages();
                this.lastModified = new Date();
            }
            this.save();
            return super.configure(req, json);
        }

        public String getHelpFile() {
            return "/plugin/jython/help.html";
        }
    }
}

