/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.FilePath;
import hudson.Plugin;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JythonPlugin
extends Plugin {
    public static final URL INSTALLER_URL = JythonPlugin.class.getResource("jython-installer-2.5.2.JENKINS.zip");
    public static final FilePath JYTHON_HOME = Hudson.getInstance().getRootPath().child("tools/jython");
    public static final String SITE_PACKAGES_PATH = "Lib/site-packages";
    private static final String EASY_INSTALL_FILENAME = "easy-install.pth";
    private static final Logger LOG = Logger.getLogger(JythonPlugin.class.toString());

    static boolean installJythonIfNecessary(FilePath targetJythonHome, TaskListener listener) throws IOException, InterruptedException {
        boolean installed = false;
        if (!targetJythonHome.child("jython.jar").exists()) {
            targetJythonHome.unzipFrom(INSTALLER_URL.openStream());
            targetJythonHome.child("jython").chmod(493);
            targetJythonHome.child("tmp").mkdirs();
            installed = true;
            listener.getLogger().println("Installed Jython runtime");
        }
        return installed;
    }

    static void syncSitePackages(FilePath targetJythonHome, TaskListener listener) throws IOException, InterruptedException {
        String pkgName;
        PrintStream logger = listener.getLogger();
        FilePath srcSitePkgs = JYTHON_HOME.child(SITE_PACKAGES_PATH);
        FilePath tgtSitePkgs = targetJythonHome.child(SITE_PACKAGES_PATH);
        srcSitePkgs.child(EASY_INSTALL_FILENAME).copyTo(tgtSitePkgs.child(EASY_INSTALL_FILENAME));
        logger.println("Copied easy-install.pth");
        for (FilePath pkgSrc : srcSitePkgs.list()) {
            pkgName = pkgSrc.getName();
            FilePath pkgTgt = tgtSitePkgs.child(pkgName);
            if (pkgTgt.exists() && pkgSrc.lastModified() <= pkgTgt.lastModified()) continue;
            if (pkgSrc.isDirectory()) {
                pkgSrc.copyRecursiveTo(pkgTgt);
            } else {
                pkgSrc.copyTo(pkgTgt);
            }
            logger.println("Copied " + pkgName);
        }
        for (FilePath pkgTgt : tgtSitePkgs.list()) {
            pkgName = pkgTgt.getName();
            FilePath pkgSrc = srcSitePkgs.child(pkgName);
            if (pkgSrc.exists()) continue;
            try {
                if (pkgTgt.isDirectory()) {
                    pkgTgt.deleteRecursive();
                } else {
                    pkgTgt.delete();
                }
                logger.println("Deleted " + pkgName);
            }
            catch (Exception e) {
                e.printStackTrace(listener.error("error deleting package - continuing with build"));
            }
        }
    }

    public void start() throws Exception {
        JythonPlugin.installJythonIfNecessary(JYTHON_HOME, (TaskListener)new LogTaskListener(LOG, Level.INFO));
    }
}

