/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.mapping;

import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.java.xml.ns.persistence.orm.Basic;
import com.sun.java.xml.ns.persistence.orm.EmbeddableAttributes;
import com.sun.java.xml.ns.persistence.orm.Transient;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CClass;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.codemodel.util.JTypeUtils;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.ClassOutlineMapping;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.FieldOutlineMapping;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.jvnet.jaxb2_commons.util.FieldAccessorUtils;

public class EmbeddableAttributesMapping
implements ClassOutlineMapping<EmbeddableAttributes> {
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public EmbeddableAttributes process(Mapping context, ClassOutline classOutline, Options options) {
        FieldOutline[] fieldOutlines;
        EmbeddableAttributes attributes = new EmbeddableAttributes();
        for (FieldOutline fieldOutline : fieldOutlines = classOutline.getDeclaredFields()) {
            Object attributeMapping = this.getAttributeMapping(context, fieldOutline, options).process(context, fieldOutline, options);
            if (attributeMapping instanceof Basic) {
                attributes.getBasic().add((Basic)attributeMapping);
                continue;
            }
            if (!(attributeMapping instanceof Transient)) continue;
            attributes.getTransient().add((Transient)attributeMapping);
        }
        return attributes;
    }

    public FieldOutlineMapping<?> getAttributeMapping(Mapping context, FieldOutline fieldOutline, Options options) {
        if (context.getIgnoring().isFieldOutlineIgnored(context, fieldOutline)) {
            return context.getTransientMapping();
        }
        if (this.isFieldOutlineId(context, fieldOutline)) {
            CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
            this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is marked as [id] field. " + "This is not supported in embeddable classes. " + "This field will be made transient."));
            return context.getTransientMapping();
        }
        if (this.isFieldOutlineEmbeddedId(context, fieldOutline)) {
            CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
            this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is marked as [embedded-id] field. " + "This is not supported in embeddable classes. " + "This field will be made transient."));
            return context.getTransientMapping();
        }
        if (this.isFieldOutlineVersion(context, fieldOutline)) {
            CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
            this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is marked as [version] field. " + "This is not supported in embeddable classes. " + "This field will be made transient."));
            return context.getTransientMapping();
        }
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        if (!propertyInfo.isCollection()) {
            this.logger.trace((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a single field."));
            Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
            if (types.size() == 1) {
                this.logger.trace((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a homogeneous single field."));
                if (this.isFieldOutlineBasic(context, fieldOutline)) {
                    return context.getBasicMapping();
                }
                if (this.isFieldOutlineComplex(context, fieldOutline)) {
                    this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a complex field. " + "This is not supported in embeddable classes. " + "This field will be made transient."));
                    return context.getTransientMapping();
                }
                this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is not a basic field. " + "This is not supported in embeddable classes. " + "This field will be made transient."));
                return context.getTransientMapping();
            }
            this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a heterogeneous field. " + "This is not supported in embeddable classes. " + "This field will be made transient."));
            return context.getTransientMapping();
        }
        this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a collection field. " + "This is not supported in embeddable classes. " + "This field will be made transient."));
        return context.getTransientMapping();
    }

    public boolean isFieldOutlineId(Mapping context, FieldOutline fieldOutline) {
        return CustomizationUtils.containsCustomization((FieldOutline)fieldOutline, (QName)Customizations.ID_ELEMENT_NAME);
    }

    public boolean isFieldOutlineVersion(Mapping context, FieldOutline fieldOutline) {
        return CustomizationUtils.containsCustomization((FieldOutline)fieldOutline, (QName)Customizations.VERSION_ELEMENT_NAME);
    }

    public boolean isFieldOutlineBasic(Mapping context, FieldOutline fieldOutline) {
        return this.isFieldOutlineCore(context, fieldOutline) || this.isFieldOutlineEnumerated(context, fieldOutline);
    }

    public boolean isFieldOutlineCore(Mapping context, FieldOutline fieldOutline) {
        JMethod getter = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
        JType type = getter.type();
        return JTypeUtils.isBasicType(type);
    }

    public boolean isFieldOutlineEnumerated(Mapping context, FieldOutline fieldOutline) {
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        if (types.size() == 1) {
            CTypeInfo type = (CTypeInfo)types.iterator().next();
            return type instanceof CEnumLeafInfo;
        }
        return false;
    }

    public boolean isFieldOutlineComplex(Mapping context, FieldOutline fieldOutline) {
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        assert (types.size() == 1);
        CTypeInfo type = (CTypeInfo)types.iterator().next();
        return type instanceof CClass;
    }

    public boolean isFieldOutlineEmbeddedId(Mapping context, FieldOutline fieldOutline) {
        return CustomizationUtils.containsCustomization((FieldOutline)fieldOutline, (QName)Customizations.EMBEDDED_ID_ELEMENT_NAME);
    }
}

