/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.model.base;

import com.sun.tools.xjc.generator.bean.field.GenericFieldRenderer;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.TypeUse;
import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.jvnet.annox.util.ClassUtils;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.GeneratedVersion;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Version;
import org.jvnet.hyperjaxb3.ejb.strategy.model.ClassInfoProcessor;
import org.jvnet.hyperjaxb3.ejb.strategy.model.ProcessModel;
import org.jvnet.hyperjaxb3.xjc.generator.bean.field.TransientSingleField;
import org.jvnet.hyperjaxb3.xjc.model.CExternalLeafInfo;

public class DefaultCreateDefaultVersionPropertyInfos
implements ClassInfoProcessor<Collection<CPropertyInfo>, ProcessModel> {
    @Override
    public Collection<CPropertyInfo> process(ProcessModel context, CClassInfo classInfo) {
        GeneratedVersion cversion = context.getCustomizing().getGeneratedVersion(classInfo);
        if (cversion == null) {
            return Collections.emptyList();
        }
        CPropertyInfo propertyInfo = this.createPropertyInfo(context, classInfo, cversion);
        return Collections.singletonList(propertyInfo);
    }

    protected CPropertyInfo createPropertyInfo(ProcessModel context, CClassInfo classInfo, GeneratedVersion cversion) {
        String propertyName = this.getPropertyName(context, cversion);
        QName attributeName = this.getAttributeName(context, cversion);
        CNonElement propertyTypeInfo = this.getPropertyTypeInfo(context, cversion);
        CCustomizations customizations = new CCustomizations();
        CPluginCustomization version = this.createVersionCustomization(context, cversion);
        customizations.add((Object)version);
        CAttributePropertyInfo propertyInfo = new CAttributePropertyInfo(propertyName, null, customizations, null, attributeName, (TypeUse)propertyTypeInfo, propertyTypeInfo.getTypeName(), false);
        if (cversion.isTransient() != null && cversion.isTransient().booleanValue()) {
            propertyInfo.realization = new GenericFieldRenderer(TransientSingleField.class);
        }
        Customizations.markGenerated((CCustomizable)propertyInfo);
        return propertyInfo;
    }

    public String getPropertyName(ProcessModel context, GeneratedVersion cversion) {
        String name = cversion.getName();
        Validate.notEmpty((CharSequence)name, (String)"The hj:version/@name attribute must not be empty.", (Object[])new Object[0]);
        return name;
    }

    public QName getAttributeName(ProcessModel context, GeneratedVersion version) {
        QName attributeName = version.getAttributeName();
        return attributeName != null ? attributeName : new QName(this.getPropertyName(context, version));
    }

    public CNonElement getPropertyTypeInfo(ProcessModel context, GeneratedVersion cversion) {
        String javaType = cversion.getJavaType();
        Validate.notEmpty((CharSequence)javaType, (String)"The hj:version/@javaType attribute must not be empty.", (Object[])new Object[0]);
        QName schemaType = cversion.getSchemaType();
        Validate.notNull((Object)schemaType, (String)"The hj:version/@schemaType attribute must not be null.", (Object[])new Object[0]);
        try {
            Class theClass = ClassUtils.forName((String)javaType);
            return new CExternalLeafInfo(theClass, schemaType, null);
        }
        catch (ClassNotFoundException cnfex) {
            throw new IllegalArgumentException("Class name [" + javaType + "] provided in the hj:version/@javaType attribute could not be resolved.", cnfex);
        }
    }

    public CPluginCustomization createVersionCustomization(ProcessModel context, GeneratedVersion cversion) {
        Version version = new Version();
        version.mergeFrom((Object)cversion, (Object)version);
        JAXBElement versionElement = Customizations.getCustomizationsObjectFactory().createVersion(version);
        return Customizations.createCustomization((Object)versionElement);
    }
}

