/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

abstract class AbstractJaxwsMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="true")
    protected boolean keep;
    @Parameter(defaultValue="false")
    protected boolean extension;
    @Parameter(property="project.build.sourceEncoding")
    private String encoding;
    @Parameter
    private List<String> args;
    @Parameter
    private List<String> vmArgs;
    @Parameter(defaultValue="true")
    private boolean xnocompile;
    @Parameter
    private File executable;
    @Parameter(property="plugin.artifactMap", readonly=true)
    private Map<String, Artifact> pluginArtifactMap;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private ArtifactMetadataSource metadataSource;
    private static final Logger logger = Logger.getLogger(AbstractJaxwsMojo.class.getName());
    private static final List<String> METRO_22 = new ArrayList<String>();
    private static final List<String> METRO_221 = new ArrayList<String>();
    private static final List<String> METRO_23 = new ArrayList<String>();

    AbstractJaxwsMojo() {
    }

    protected abstract String getMain();

    protected abstract File getDestDir();

    protected abstract File getSourceDestDir();

    protected void addSourceRoot(String sourceDir) {
        if (!this.project.getCompileSourceRoots().contains(sourceDir)) {
            this.getLog().debug((CharSequence)("adding src root: " + sourceDir));
            this.project.addCompileSourceRoot(sourceDir);
        } else {
            this.getLog().debug((CharSequence)("existing src root: " + sourceDir));
        }
    }

    protected abstract File getDefaultSrcOut();

    protected String getExtraClasspath() {
        return null;
    }

    protected List<String> getCommonArgs() throws MojoExecutionException {
        File destDir;
        ArrayList<String> commonArgs = new ArrayList<String>();
        if (!this.isDefaultSrc(this.getSourceDestDir()) || this.keep) {
            commonArgs.add("-keep");
            commonArgs.add("-s");
            commonArgs.add(this.getSourceDestDir().getAbsolutePath());
            if (!this.getSourceDestDir().mkdirs() && !this.getSourceDestDir().exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + this.getSourceDestDir().getAbsolutePath()));
            }
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
        if (!(destDir = this.getDestDir()).mkdirs() && !destDir.exists()) {
            this.getLog().warn((CharSequence)("Cannot create directory: " + destDir.getAbsolutePath()));
        }
        commonArgs.add("-d");
        commonArgs.add(destDir.getAbsolutePath());
        if (this.verbose) {
            commonArgs.add("-verbose");
        }
        if (this.isArgSupported("-encoding")) {
            if (this.encoding != null) {
                this.maybeUnsupportedOption("-encoding", this.encoding, commonArgs);
            } else {
                this.getLog().warn((CharSequence)("Using platform encoding (" + System.getProperty("file.encoding") + "), build is platform dependent!"));
            }
        }
        if (this.extension) {
            commonArgs.add("-extension");
        }
        if (this.xnocompile) {
            commonArgs.add("-Xnocompile");
        }
        if (this.args != null) {
            for (String arg : this.args) {
                commonArgs.add(arg);
            }
        }
        return commonArgs;
    }

    protected boolean isArgSupported(String arg) throws MojoExecutionException {
        boolean isSupported = true;
        Artifact a = this.pluginArtifactMap.get("com.sun.xml.ws:jaxws-tools");
        List<String> supportedArgs = null;
        String v = null;
        try {
            if (a != null) {
                ArtifactVersion av = a.getSelectedVersion();
                v = av.toString();
                supportedArgs = av.getMajorVersion() == 2 && av.getMinorVersion() == 2 && av.getIncrementalVersion() == 6 ? METRO_22 : (av.getMajorVersion() == 2 && av.getMinorVersion() == 2 && av.getIncrementalVersion() == 7 ? METRO_221 : METRO_23);
            } else {
                a = this.pluginArtifactMap.get("org.glassfish.metro:webservices-tools");
                ArtifactVersion av = a.getSelectedVersion();
                v = av.toString();
                supportedArgs = av.getMajorVersion() == 2 && av.getMinorVersion() == 2 && av.getIncrementalVersion() == 0 ? METRO_22 : (av.getMajorVersion() == 2 && av.getMinorVersion() == 2 && av.getIncrementalVersion() >= 1 ? METRO_221 : METRO_23);
            }
        }
        catch (OverConstrainedVersionException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        isSupported = supportedArgs.contains(arg);
        if (!isSupported) {
            this.getLog().warn((CharSequence)("'" + arg + "' is not supported by " + a.getArtifactId() + ":" + v));
        }
        return isSupported;
    }

    private boolean isDefaultSrc(File srcout) {
        return srcout.equals(this.getDefaultSrcOut());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void exec(List<String> args) throws MojoExecutionException {
        DefaultConsumer sc = new DefaultConsumer();
        try {
            Commandline cmd = new Commandline();
            if (this.executable != null) {
                if (!this.executable.isFile() || !this.executable.canExecute()) throw new MojoExecutionException("Cannot execute: " + this.executable.getAbsolutePath());
                cmd.setExecutable(this.executable.getAbsolutePath());
                if (this.getExtraClasspath() != null) {
                    cmd.createArg().setLine("-cp " + this.getExtraClasspath());
                }
            } else {
                cmd.setExecutable(new File(new File(System.getProperty("java.home"), "bin"), this.getJavaExec()).getAbsolutePath());
                if (this.vmArgs != null) {
                    for (String arg : this.vmArgs) {
                        cmd.createArg().setLine(arg);
                    }
                }
                String[] classpath = this.getCP();
                cmd.createArg().setLine("-Xbootclasspath/p:" + classpath[0]);
                cmd.createArg().setLine("-cp " + classpath[2]);
                cmd.createArg().setLine("org.jvnet.jax_ws_commons.jaxws.Invoker");
                cmd.createArg().setLine(this.getMain());
                File pathFile = this.createPathFile((this.getExtraClasspath() != null ? this.getExtraClasspath() + File.pathSeparator : "") + classpath[1]);
                cmd.createArg().setLine("-pathfile " + pathFile.getAbsolutePath());
                if (this.getExtraClasspath() != null) {
                    cmd.createArg().setLine("-cp " + this.getExtraClasspath());
                }
            }
            cmd.setWorkingDirectory(this.project.getBasedir());
            for (String arg : args) {
                cmd.createArg().setLine(arg);
            }
            this.getLog().debug((CharSequence)cmd.toString());
            if (CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)sc, (StreamConsumer)sc) == 0) return;
            throw new MojoExecutionException("Mojo failed - check output");
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t.getMessage(), t);
        }
    }

    protected void maybeUnsupportedOption(String option, String value, List<String> args) {
        if (this.executable == null) {
            args.add(option);
            if (value != null) {
                args.add(value);
            }
        } else {
            this.getLog().warn((CharSequence)(option + " may not supported on older JDKs.\n" + "Use <args> to bypass this warning if you really want to use it."));
        }
    }

    private String[] getCP() throws ArtifactResolutionException, ArtifactNotFoundException {
        HashSet cp = new HashSet();
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        List plugins = this.project.getBuildPlugins();
        for (Plugin p : plugins) {
            if (!"jaxws-maven-plugin".equals(p.getArtifactId()) || !"org.jvnet.jax-ws-commons".equals(p.getGroupId())) continue;
            boolean toolsAdded = false;
            for (Dependency d : p.getDependencies()) {
                HashSet<Artifact> toInclude = new HashSet<Artifact>();
                ArrayList<String> toExclude = new ArrayList<String>();
                for (Exclusion e : d.getExclusions()) {
                    toExclude.add(e.getGroupId() + ":" + e.getArtifactId());
                    this.getLog().debug((CharSequence)("excluding: " + e.getGroupId() + ":" + e.getArtifactId()));
                }
                if ("jaxws-tools".equals(p.getArtifactId()) && "com.sun.xml.ws".equals(p.getGroupId()) || "webservices-tools".equals(p.getArtifactId()) && "org.glassfish.metro".equals(p.getGroupId())) {
                    toolsAdded = true;
                }
                toInclude.add(this.pluginArtifactMap.get(d.getGroupId() + ":" + d.getArtifactId()));
                ExcludesArtifactFilter filter = new ExcludesArtifactFilter(toExclude);
                this.getLog().debug((CharSequence)("resolving: " + d.getGroupId() + ":" + d.getArtifactId()));
                ArtifactResolutionResult res = this.artifactResolver.resolveTransitively(toInclude, originatingArtifact, this.localRepository, this.remoteRepositories, this.metadataSource, (ArtifactFilter)filter);
                cp.addAll(res.getArtifacts());
            }
            if (toolsAdded) break;
            ArtifactResolutionResult res = this.artifactResolver.resolveTransitively(Collections.singleton(this.pluginArtifactMap.get("com.sun.xml.ws:jaxws-tools")), originatingArtifact, this.remoteRepositories, this.localRepository, this.metadataSource);
            cp.addAll(res.getArtifacts());
            break;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder esb = new StringBuilder();
        for (Artifact a : cp) {
            if ("jaxws-api".equals(a.getArtifactId()) || "jaxb-api".equals(a.getArtifactId()) || "saaj-api".equals(a.getArtifactId()) || "jsr181-api".equals(a.getArtifactId()) || "javax.annotation".equals(a.getArtifactId())) {
                esb.append(a.getFile().getAbsolutePath());
                esb.append(File.pathSeparator);
                continue;
            }
            sb.append(a.getFile().getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        String invokerPath = AbstractJaxwsMojo.class.getProtectionDomain().getCodeSource().getLocation().toExternalForm();
        invokerPath = invokerPath.substring(5);
        sb.append(invokerPath);
        sb.append(File.pathSeparator);
        File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(System.getProperty("java.home"), "lib/tools.jar");
        }
        sb.append(toolsJar.getAbsolutePath());
        sb.append(File.pathSeparator);
        return new String[]{esb.substring(0, esb.length() - 1), sb.substring(0, sb.length() - 1), invokerPath};
    }

    private String getJavaExec() {
        return Os.isFamily((String)"windows") ? "java.exe" : "java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPathFile(String cp) {
        File f = new File(System.getProperty("java.io.tmpdir"), "jm.txt");
        if (f.exists() && f.isFile() && !f.delete()) {
            this.getLog().warn((CharSequence)("cannot remove obsolete classpath setting file: " + f.getAbsolutePath()));
        }
        Properties p = new Properties();
        p.put("cp", cp.replace(File.separatorChar, '/'));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            p.store(fos, null);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return f;
    }

    static {
        METRO_22.add("-encoding");
        METRO_22.add("-clientjar");
        METRO_22.add("-generateJWS");
        METRO_22.add("-implDestDir");
        METRO_22.add("-implServiceName");
        METRO_22.add("-implPortName");
        METRO_221.addAll(METRO_22);
        METRO_221.add("-XdisableAuthenticator");
        METRO_23.addAll(METRO_221);
    }
}

