/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.maven.jellydoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.txw2.output.XmlSerializer;
import java.beans.Introspector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import org.cyberneko.html.parsers.SAXParser;
import org.jvnet.maven.jellydoc.Attribute;
import org.jvnet.maven.jellydoc.Item;
import org.jvnet.maven.jellydoc.Library;
import org.jvnet.maven.jellydoc.Tag;
import org.jvnet.maven.jellydoc.Tags;
import org.jvnet.maven.jellydoc.annotation.NoContent;
import org.jvnet.maven.jellydoc.annotation.Required;
import org.jvnet.maven.jellydoc.annotation.TagLibUri;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagXMLDoclet
extends Doclet {
    private String targetFileName = null;
    private String encodingFormat;

    public TagXMLDoclet(RootDoc root) throws Exception {
        this.readOptions(root);
        File targetFile = new File(this.targetFileName);
        targetFile.getParentFile().mkdirs();
        FileOutputStream writer = new FileOutputStream(this.targetFileName);
        Tags tw = (Tags)TXW.create(Tags.class, (XmlSerializer)new StreamSerializer((OutputStream)writer));
        this.javadocXML(root, tw);
        tw.commit();
    }

    private void javadocXML(RootDoc root, Tags tw) throws SAXException {
        HashSet<PackageDoc> pkgs = new HashSet<PackageDoc>();
        for (ClassDoc c : root.specifiedClasses()) {
            pkgs.add(c.containingPackage());
        }
        pkgs.addAll(Arrays.asList(root.specifiedPackages()));
        for (PackageDoc pkg : pkgs) {
            this.packageXML(pkg, tw);
        }
    }

    private void packageXML(PackageDoc packageDoc, Tags tw) throws SAXException {
        System.out.println("processing package: " + packageDoc.name());
        ClassDoc[] classArray = packageDoc.ordinaryClasses();
        boolean foundTag = false;
        for (ClassDoc classDoc : classArray) {
            if (!this.isTag(classDoc)) continue;
            foundTag = true;
            break;
        }
        if (!foundTag) {
            return;
        }
        Library library = tw.library();
        library.name(packageDoc.name());
        String name = packageDoc.name();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            name = name.substring(idx + 1);
        }
        library.prefix(name);
        String uri = this.findUri(packageDoc.annotations());
        if (uri == null) {
            uri = "jelly:" + name;
        }
        library.uri(uri);
        this.docXML((Doc)packageDoc, (Item)library);
        for (ClassDoc c : classArray) {
            if (!this.isTag(c)) continue;
            this.tagXML(c, library.tag());
        }
    }

    private String findUri(AnnotationDesc[] an) {
        for (AnnotationDesc a : an) {
            if (!a.annotationType().qualifiedName().equals(TagLibUri.class.getName())) continue;
            for (AnnotationDesc.ElementValuePair e : a.elementValues()) {
                if (!e.element().name().equals("value")) continue;
                return e.value().value().toString();
            }
        }
        return null;
    }

    private boolean has(ProgramElementDoc doc, Class<? extends Annotation> type) {
        for (AnnotationDesc a : doc.annotations()) {
            if (!a.annotationType().qualifiedName().equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isTag(ClassDoc classDoc) {
        ClassDoc[] interfaceArray;
        for (ClassDoc i : interfaceArray = classDoc.interfaces()) {
            String name = i.qualifiedName();
            if (!"org.apache.commons.jelly.Tag".equals(name)) continue;
            return true;
        }
        ClassDoc base = classDoc.superclass();
        return base != null && this.isTag(base);
    }

    private void tagXML(ClassDoc classDoc, Tag tag) throws SAXException {
        if (classDoc.isAbstract()) {
            return;
        }
        tag.className(classDoc.name());
        String name = classDoc.name();
        if (name.endsWith("Tag")) {
            name = name.substring(0, name.length() - 3);
        }
        name = Introspector.decapitalize(name);
        System.out.println("processing tag: " + name);
        tag.name(name);
        if (this.has((ProgramElementDoc)classDoc, NoContent.class)) {
            tag.noContent(true);
        }
        this.docXML((Doc)classDoc, (Item)tag);
        this.propertiesXML(classDoc, tag);
    }

    private void propertiesXML(ClassDoc classDoc, Tag tag) throws SAXException {
        MethodDoc[] methodArray;
        for (MethodDoc m : methodArray = classDoc.methods()) {
            this.propertyXML(m, tag);
        }
        ClassDoc base = classDoc.superclass();
        if (base != null) {
            this.propertiesXML(base, tag);
        }
    }

    private void propertyXML(MethodDoc methodDoc, Tag tag) throws SAXException {
        if (!methodDoc.isPublic() || methodDoc.isStatic()) {
            return;
        }
        String name = methodDoc.name();
        if (!name.startsWith("set")) {
            return;
        }
        Parameter[] parameterArray = methodDoc.parameters();
        if (parameterArray == null || parameterArray.length != 1) {
            return;
        }
        Parameter parameter = parameterArray[0];
        name = name.substring(3);
        if ((name = Introspector.decapitalize(name)).equals("body") || name.equals("context") || name.equals("parent")) {
            return;
        }
        Attribute a = tag.attribute();
        a.name(name);
        a.type(parameter.typeName());
        if (this.has((ProgramElementDoc)methodDoc, Required.class)) {
            a.use("required");
        }
        this.docXML((Doc)methodDoc, (Item)a);
    }

    private void docXML(Doc doc, Item w) throws SAXException {
        TypedXmlWriter d = w.doc();
        for (com.sun.javadoc.Tag tag : doc.inlineTags()) {
            if (tag instanceof SeeTag) {
                String label = ((SeeTag)tag).label();
                if (null == label || "".equals(label)) {
                    String memberName;
                    StringBuilder buf = new StringBuilder();
                    String className = ((SeeTag)tag).referencedClassName();
                    if ("".equals(className)) {
                        className = null;
                    }
                    if ("".equals(memberName = ((SeeTag)tag).referencedMemberName())) {
                        memberName = null;
                    }
                    if (null != className) {
                        buf.append(className);
                        if (null != memberName) {
                            buf.append(".");
                        }
                    }
                    if (null != memberName) {
                        buf.append(memberName);
                    }
                    label = buf.toString();
                }
                this.parseHTML(label, d);
                continue;
            }
            this.parseHTML(tag.text(), d);
        }
        for (com.sun.javadoc.Tag tag : doc.tags()) {
            this.javadocTagXML(tag, w);
        }
    }

    protected void parseHTML(String text, final TypedXmlWriter d) throws SAXException {
        SAXParser parser = new SAXParser();
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
        parser.setContentHandler((ContentHandler)new DefaultHandler(){
            private Stack<TypedXmlWriter> w = new Stack();
            {
                this.w.push(d);
            }

            @Override
            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                if (TagXMLDoclet.this.validDocElementName(localName)) {
                    this.w.push(this.w.peek()._element(localName, TypedXmlWriter.class));
                }
            }

            @Override
            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                if (TagXMLDoclet.this.validDocElementName(localName)) {
                    this.w.pop();
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this.w.peek()._pcdata((Object)new String(ch, start, length));
            }
        });
        try {
            parser.parse(new InputSource(new StringReader(text)));
        }
        catch (IOException e) {
            System.err.println("This should never happen!" + e);
        }
    }

    protected boolean validDocElementName(String name) {
        return !name.equalsIgnoreCase("html") && !name.equalsIgnoreCase("body");
    }

    private void javadocTagXML(com.sun.javadoc.Tag tag, Item w) throws SAXException {
        String name = tag.name().substring(1) + "tag";
        if (!tag.text().equals("")) {
            w._element(name, TypedXmlWriter.class)._pcdata((Object)tag.text());
        }
    }

    public static boolean start(RootDoc root) {
        try {
            new TagXMLDoclet(root);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }

    private void readOptions(RootDoc root) {
        for (String[] opt : root.options()) {
            if (opt[0].equals("-d")) {
                this.targetFileName = opt[1] + "/taglib.xml";
            }
            if (!opt[0].equals("-encoding")) continue;
            this.encodingFormat = opt[1];
        }
    }

    public static int optionLength(String option) {
        if (option.equals("-d")) {
            return 2;
        }
        if (option.equals("-encoding")) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean foundEncodingOption = false;
        boolean foundDirOption = false;
        for (String[] opt : options) {
            if (opt[0].equals("-d")) {
                if (foundDirOption) {
                    reporter.printError("Only one -d option allowed.");
                    return false;
                }
                foundDirOption = true;
            }
            if (!opt[0].equals("-encoding")) continue;
            if (foundEncodingOption) {
                reporter.printError("Only one -encoding option allowed.");
                return false;
            }
            foundEncodingOption = true;
        }
        if (!foundDirOption) {
            reporter.printError("Usage: javadoc -d <directory> -doclet TagXMLDoclet ...");
            return false;
        }
        return true;
    }
}

