/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.reader;

import java.util.Date;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.jxls.reader.DateConverter;

public class ReaderConfig {
    private static ReaderConfig ourInstance = new ReaderConfig();
    private boolean skipErrors = false;
    private boolean useDefaultValuesForPrimitiveTypes = true;
    private static Character defaultCharacter = Character.valueOf(' ');
    private static Byte defaultByte = 0;
    private static Boolean defaultBoolean = Boolean.FALSE;
    private static Double defaultDouble = 0.0;
    private static Float defaultFloat = Float.valueOf(0.0f);
    private static Integer defaultInteger = 0;
    private static Long defaultLong = 0L;
    private static Short defaultShort = 0;
    private ConvertUtilsBean convertUtilsBean = null;

    public static ConvertUtilsBean createConvertUtilsBean(boolean useDefaultValuesForPrimitiveTypes) {
        return ReaderConfig.initializeConverters(useDefaultValuesForPrimitiveTypes);
    }

    public ConvertUtilsBean getConvertUtilsBean() {
        if (this.convertUtilsBean == null) {
            this.convertUtilsBean = ReaderConfig.initializeConverters(this.useDefaultValuesForPrimitiveTypes);
        }
        return this.convertUtilsBean;
    }

    public static ReaderConfig getInstance() {
        return ourInstance;
    }

    private ReaderConfig() {
        this.setUseDefaultValuesForPrimitiveTypes(false);
    }

    public boolean isSkipErrors() {
        return this.skipErrors;
    }

    public void setSkipErrors(boolean skipErrors) {
        this.skipErrors = skipErrors;
    }

    public boolean isUseDefaultValuesForPrimitiveTypes() {
        return this.useDefaultValuesForPrimitiveTypes;
    }

    public void setUseDefaultValuesForPrimitiveTypes(boolean useDefaultValuesForPrimitiveTypes) {
        this.useDefaultValuesForPrimitiveTypes = useDefaultValuesForPrimitiveTypes;
    }

    private static ConvertUtilsBean initializeConverters(boolean useDefaultValuesForPrimitiveTypes) {
        CharacterConverter characterConverter;
        FloatConverter floatConverter;
        BooleanConverter booleanConverter;
        ShortConverter shortConverter;
        LongConverter longConverter;
        DoubleConverter doubleConverter;
        ByteConverter byteConverter;
        IntegerConverter integerConverter;
        ConvertUtilsBean converterUtilsBean = new ConvertUtilsBean();
        if (useDefaultValuesForPrimitiveTypes) {
            integerConverter = new IntegerConverter((Object)defaultInteger);
            byteConverter = new ByteConverter((Object)defaultByte);
            doubleConverter = new DoubleConverter((Object)defaultDouble);
            longConverter = new LongConverter((Object)defaultLong);
            shortConverter = new ShortConverter((Object)defaultShort);
            booleanConverter = new BooleanConverter((Object)defaultBoolean);
            floatConverter = new FloatConverter((Object)defaultFloat);
            characterConverter = new CharacterConverter((Object)defaultCharacter);
        } else {
            integerConverter = new IntegerConverter();
            byteConverter = new ByteConverter();
            doubleConverter = new DoubleConverter();
            longConverter = new LongConverter();
            shortConverter = new ShortConverter();
            booleanConverter = new BooleanConverter();
            floatConverter = new FloatConverter();
            characterConverter = new CharacterConverter();
        }
        converterUtilsBean.register((Converter)integerConverter, Integer.TYPE);
        converterUtilsBean.register((Converter)integerConverter, Integer.class);
        converterUtilsBean.register((Converter)byteConverter, Byte.TYPE);
        converterUtilsBean.register((Converter)byteConverter, Byte.class);
        converterUtilsBean.register((Converter)doubleConverter, Double.TYPE);
        converterUtilsBean.register((Converter)doubleConverter, Double.class);
        converterUtilsBean.register((Converter)longConverter, Long.TYPE);
        converterUtilsBean.register((Converter)longConverter, Long.class);
        converterUtilsBean.register((Converter)shortConverter, Short.TYPE);
        converterUtilsBean.register((Converter)shortConverter, Short.class);
        converterUtilsBean.register((Converter)booleanConverter, Boolean.TYPE);
        converterUtilsBean.register((Converter)booleanConverter, Boolean.class);
        converterUtilsBean.register((Converter)floatConverter, Float.TYPE);
        converterUtilsBean.register((Converter)floatConverter, Float.class);
        converterUtilsBean.register((Converter)characterConverter, Character.TYPE);
        converterUtilsBean.register((Converter)characterConverter, Character.class);
        converterUtilsBean.register((Converter)new DateConverter(), Date.class);
        return converterUtilsBean;
    }
}

