/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.reader;

import java.util.NoSuchElementException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.jxls.reader.XLSRowCursor;

public class XLSRowCursorImpl
implements XLSRowCursor {
    int currentRowNum;
    Sheet sheet;
    String sheetName;

    public XLSRowCursorImpl(Sheet sheet) {
        this.sheet = sheet;
    }

    public XLSRowCursorImpl(String sheetName, Sheet sheet) {
        this.sheetName = sheetName;
        this.sheet = sheet;
    }

    @Override
    public int getCurrentRowNum() {
        return this.currentRowNum;
    }

    @Override
    public Row getCurrentRow() {
        return this.sheet.getRow(this.currentRowNum);
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }

    @Override
    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public Row next() {
        if (this.hasNext()) {
            return this.sheet.getRow(this.currentRowNum++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        return this.currentRowNum <= this.sheet.getLastRowNum();
    }

    @Override
    public void reset() {
        this.currentRowNum = 0;
    }

    @Override
    public void setCurrentRowNum(int rowNum) {
        this.currentRowNum = rowNum;
    }

    @Override
    public void moveForward() {
        ++this.currentRowNum;
    }

    @Override
    public void moveBackward() {
        --this.currentRowNum;
    }
}

