/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.workflows;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.workflows.AbstractWorkflowComponentRepresentation;
import org.keycloak.representations.workflows.MultivaluedHashMapValueDeserializer;
import org.keycloak.representations.workflows.MultivaluedHashMapValueSerializer;

@JsonPropertyOrder(value={"id", "uses", "after", "priority", "with"})
public final class WorkflowStepRepresentation
extends AbstractWorkflowComponentRepresentation {
    public static Builder create() {
        return new Builder();
    }

    public WorkflowStepRepresentation() {
        this(null, null, null);
    }

    public WorkflowStepRepresentation(String uses) {
        this(null, uses, null);
    }

    public WorkflowStepRepresentation(String id, String uses, MultivaluedHashMap<String, String> config) {
        super(id, uses, config);
    }

    @Override
    @JsonSerialize(using=MultivaluedHashMapValueSerializer.class)
    @JsonDeserialize(using=MultivaluedHashMapValueDeserializer.class)
    public MultivaluedHashMap<String, String> getConfig() {
        return super.getConfig();
    }

    public String getAfter() {
        return this.getConfigValue("after", String.class);
    }

    public void setAfter(long ms) {
        this.setConfig("after", String.valueOf(ms));
    }

    public String getPriority() {
        return this.getConfigValue("priority", String.class);
    }

    public void setPriority(long ms) {
        this.setConfig("priority", String.valueOf(ms));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkflowStepRepresentation)) {
            return false;
        }
        WorkflowStepRepresentation that = (WorkflowStepRepresentation)obj;
        return Objects.equals(this.getUses(), that.getUses()) && Objects.equals(this.getConfig(), that.getConfig());
    }

    public static class Builder {
        private WorkflowStepRepresentation step;

        public Builder of(String providerId) {
            this.step = new WorkflowStepRepresentation(providerId);
            return this;
        }

        public Builder after(Duration duration) {
            this.step.setAfter(duration.toMillis());
            return this;
        }

        public Builder id(String id) {
            this.step.setId(id);
            return this;
        }

        public Builder before(WorkflowStepRepresentation targetStep, Duration timeBeforeTarget) {
            String targetAfter = (String)((List)targetStep.getConfig().get("after")).get(0);
            long targetTime = Long.parseLong(targetAfter);
            long thisTime = targetTime - timeBeforeTarget.toMillis();
            this.step.setAfter(thisTime);
            return this;
        }

        public Builder withConfig(String key, String value) {
            this.step.setConfig(key, value);
            return this;
        }

        public Builder withConfig(String key, String ... value) {
            this.step.setConfig(key, Arrays.asList(value));
            return this;
        }

        public WorkflowStepRepresentation build() {
            return this.step;
        }
    }
}

