/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.util.JsonSerialization;

public class CredentialModel
implements Serializable {
    @Deprecated
    public static final String PASSWORD = "password";
    @Deprecated
    public static final String PASSWORD_HISTORY = "password-history";
    @Deprecated
    public static final String PASSWORD_TOKEN = "password-token";
    @Deprecated
    public static final String OTP = "otp";
    @Deprecated
    public static final String TOTP = "totp";
    @Deprecated
    public static final String HOTP = "hotp";
    public static final String SECRET = "secret";
    public static final String CLIENT_CERT = "cert";
    public static final String KERBEROS = "kerberos";
    private String id;
    private String type;
    private String userLabel;
    private Long createdDate;
    private String secretData;
    private String credentialData;

    public CredentialModel shallowClone() {
        CredentialModel res = new CredentialModel();
        res.id = this.id;
        res.type = this.type;
        res.userLabel = this.userLabel;
        res.createdDate = this.createdDate;
        res.secretData = this.secretData;
        res.credentialData = this.credentialData;
        return res;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public void setUserLabel(String userLabel) {
        this.userLabel = userLabel;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public String getSecretData() {
        return this.secretData;
    }

    public void setSecretData(String secretData) {
        this.secretData = secretData;
    }

    public String getCredentialData() {
        return this.credentialData;
    }

    public void setCredentialData(String credentialData) {
        this.credentialData = credentialData;
    }

    public static Comparator<CredentialModel> comparingByStartDateDesc() {
        return (o1, o2) -> {
            Long o1Date = o1.getCreatedDate() == null ? Long.MIN_VALUE : o1.getCreatedDate();
            Long o2Date = o2.getCreatedDate() == null ? Long.MIN_VALUE : o2.getCreatedDate();
            return -o1Date.compareTo(o2Date);
        };
    }

    @Deprecated
    @JsonIgnore
    public String getValue() {
        return this.readString("value", true);
    }

    @Deprecated
    public void setValue(String value) {
        this.writeProperty("value", value, true);
    }

    @Deprecated
    @JsonIgnore
    public String getDevice() {
        return this.readString("device", false);
    }

    @Deprecated
    public void setDevice(String device) {
        this.writeProperty("device", device, false);
    }

    @Deprecated
    @JsonIgnore
    public byte[] getSalt() {
        try {
            String saltStr = this.readString("salt", true);
            return saltStr == null ? null : Base64.decode(saltStr);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Deprecated
    public void setSalt(byte[] salt) {
        String saltStr = salt == null ? null : Base64.encodeBytes(salt);
        this.writeProperty("salt", saltStr, true);
    }

    @Deprecated
    @JsonIgnore
    public int getHashIterations() {
        return this.readInt("hashIterations", false);
    }

    @Deprecated
    public void setHashIterations(int iterations) {
        this.writeProperty("hashIterations", iterations, false);
    }

    @Deprecated
    @JsonIgnore
    public int getCounter() {
        return this.readInt("counter", false);
    }

    @Deprecated
    public void setCounter(int counter) {
        this.writeProperty("counter", counter, false);
    }

    @Deprecated
    @JsonIgnore
    public String getAlgorithm() {
        return this.readString("algorithm", false);
    }

    @Deprecated
    public void setAlgorithm(String algorithm) {
        this.writeProperty("algorithm", algorithm, false);
    }

    @Deprecated
    @JsonIgnore
    public int getDigits() {
        return this.readInt("digits", false);
    }

    @Deprecated
    public void setDigits(int digits) {
        this.writeProperty("digits", digits, false);
    }

    @Deprecated
    @JsonIgnore
    public int getPeriod() {
        return this.readInt("period", false);
    }

    @Deprecated
    public void setPeriod(int period) {
        this.writeProperty("period", period, false);
    }

    @Deprecated
    @JsonIgnore
    public MultivaluedHashMap<String, String> getConfig() {
        Map<String, Object> credentialData = this.readMapFromJson(false);
        if (credentialData == null) {
            return null;
        }
        Object obj = credentialData.get("config");
        return obj == null ? null : new MultivaluedHashMap((Map)obj);
    }

    @Deprecated
    public void setConfig(MultivaluedHashMap<String, String> config) {
        this.writeProperty("config", config, false);
    }

    private Map<String, Object> readMapFromJson(boolean secret) {
        String jsonStr;
        String string = jsonStr = secret ? this.secretData : this.credentialData;
        if (jsonStr == null) {
            return new HashMap<String, Object>();
        }
        try {
            return JsonSerialization.readValue(jsonStr, Map.class);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void writeMapAsJson(Map<String, Object> map, boolean secret) {
        try {
            String jsonStr = JsonSerialization.writeValueAsString(map);
            if (secret) {
                this.secretData = jsonStr;
            } else {
                this.credentialData = jsonStr;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private String readString(String key, boolean secret) {
        Map<String, Object> credentialDataMap = this.readMapFromJson(secret);
        return (String)credentialDataMap.get(key);
    }

    private int readInt(String key, boolean secret) {
        Map<String, Object> credentialDataMap = this.readMapFromJson(secret);
        Object obj = credentialDataMap.get(key);
        return obj == null ? 0 : (Integer)obj;
    }

    private void writeProperty(String key, Object value, boolean secret) {
        Map<String, Object> credentialDataMap = this.readMapFromJson(secret);
        if (value == null) {
            credentialDataMap.remove(key);
        } else {
            credentialDataMap.put(key, value);
        }
        this.writeMapAsJson(credentialDataMap, secret);
    }
}

