/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.cert.ocsp.jcajce.JcaCertificateID;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.utils.OCSPProvider;

public class BCOCSPProvider
extends OCSPProvider {
    private static final Logger logger = Logger.getLogger(BCOCSPProvider.class.getName());

    protected OCSPResp getResponse(KeycloakSession session, OCSPReq ocspReq, URI responderUri) throws IOException {
        byte[] data = this.getEncodedOCSPResponse(session, ocspReq.getEncoded(), responderUri);
        return new OCSPResp(data);
    }

    @Override
    protected OCSPProvider.OCSPRevocationStatus check(KeycloakSession session, X509Certificate cert, X509Certificate issuerCertificate, List<URI> responderURIs, X509Certificate responderCert, Date date) throws CertPathValidatorException {
        if (responderURIs == null || responderURIs.size() == 0) {
            throw new IllegalArgumentException("Need at least one responder");
        }
        try {
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().build();
            DigestCalculator digCalc = dcp.get(CertificateID.HASH_SHA1);
            JcaCertificateID certificateID = new JcaCertificateID(digCalc, issuerCertificate, cert.getSerialNumber());
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            BigInteger nounce = BigInteger.valueOf(Math.abs(random.nextInt()));
            DEROctetString derString = new DEROctetString(nounce.toByteArray());
            Extension nounceExtension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)derString);
            Extensions extensions = new Extensions(nounceExtension);
            OCSPReq ocspReq = new OCSPReqBuilder().addRequest((CertificateID)certificateID, extensions).build();
            URI responderURI = responderURIs.get(0);
            logger.log(Level.INFO, "OCSP Responder {0}", responderURI);
            try {
                OCSPResp resp = this.getResponse(session, ocspReq, responderURI);
                logger.log(Level.FINE, "Received a response from OCSP responder {0}, the response status is {1}", new Object[]{responderURI, resp.getStatus()});
                switch (resp.getStatus()) {
                    case 0: {
                        if (resp.getResponseObject() instanceof BasicOCSPResp) {
                            return this.processBasicOCSPResponse(issuerCertificate, responderCert, date, certificateID, nounce, (BasicOCSPResp)resp.getResponseObject());
                        }
                        throw new CertPathValidatorException("OCSP responder returned an invalid or unknown OCSP response.");
                    }
                    case 2: 
                    case 3: {
                        throw new CertPathValidatorException("Internal error/try later. OCSP response error: " + resp.getStatus(), null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
                    }
                    case 5: {
                        throw new CertPathValidatorException("Invalid or missing signature. OCSP response error: " + resp.getStatus(), null, null, -1, CertPathValidatorException.BasicReason.INVALID_SIGNATURE);
                    }
                    case 6: {
                        throw new CertPathValidatorException("Unauthorized request. OCSP response error: " + resp.getStatus(), null, null, -1, CertPathValidatorException.BasicReason.UNSPECIFIED);
                    }
                }
                throw new CertPathValidatorException("OCSP request is malformed. OCSP response error: " + resp.getStatus(), null, null, -1, CertPathValidatorException.BasicReason.UNSPECIFIED);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "OCSP Responder \"{0}\" failed to return a valid OCSP response\n{1}", new Object[]{responderURI, e.getMessage()});
                throw new CertPathValidatorException("OCSP check failed", e);
            }
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CertificateEncodingException | CertificateExpiredException | CertificateNotYetValidException | OCSPException | OperatorCreationException e) {
            logger.log(Level.FINE, e.getMessage());
            throw new CertPathValidatorException(e.getMessage(), e);
        }
    }

    private OCSPProvider.OCSPRevocationStatus processBasicOCSPResponse(X509Certificate issuerCertificate, X509Certificate responderCertificate, Date date, JcaCertificateID certificateID, BigInteger nounce, BasicOCSPResp basicOcspResponse) throws OCSPException, NoSuchProviderException, NoSuchAlgorithmException, CertificateNotYetValidException, CertificateExpiredException, CertPathValidatorException {
        SingleResp expectedResponse = null;
        for (SingleResp singleResponse : basicOcspResponse.getResponses()) {
            if (!this.compareCertIDs(certificateID, singleResponse.getCertID())) continue;
            expectedResponse = singleResponse;
            break;
        }
        if (expectedResponse != null) {
            this.verifyResponse(basicOcspResponse, issuerCertificate, responderCertificate, nounce.toByteArray(), date);
            return this.singleResponseToRevocationStatus(expectedResponse);
        }
        throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
    }

    private boolean compareCertIDs(JcaCertificateID idLeft, CertificateID idRight) {
        if (idLeft == idRight) {
            return true;
        }
        if (idLeft == null || idRight == null) {
            return false;
        }
        return Arrays.equals(idLeft.getIssuerKeyHash(), idRight.getIssuerKeyHash()) && Arrays.equals(idLeft.getIssuerNameHash(), idRight.getIssuerNameHash()) && idLeft.getSerialNumber().equals(idRight.getSerialNumber());
    }

    private void verifyResponse(BasicOCSPResp basicOcspResponse, X509Certificate issuerCertificate, X509Certificate responderCertificate, byte[] requestNonce, Date date) throws NoSuchProviderException, NoSuchAlgorithmException, CertificateNotYetValidException, CertificateExpiredException, CertPathValidatorException {
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>(Arrays.asList(basicOcspResponse.getCerts()));
        Certificate signingCert = null;
        try {
            certs.add((X509CertificateHolder)new JcaX509CertificateHolder(issuerCertificate));
            if (responderCertificate != null) {
                certs.add((X509CertificateHolder)new JcaX509CertificateHolder(responderCertificate));
            }
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        if (certs.size() > 0) {
            X500Name responderName = basicOcspResponse.getResponderId().toASN1Primitive().getName();
            byte[] responderKey = basicOcspResponse.getResponderId().toASN1Primitive().getKeyHash();
            if (responderName != null) {
                logger.log(Level.INFO, "Responder Name: {0}", responderName.toString());
                for (X509CertificateHolder x509CertificateHolder : certs) {
                    try {
                        X509Certificate tempCert = new JcaX509CertificateConverter().setProvider(BouncyIntegration.PROVIDER).getCertificate(x509CertificateHolder);
                        X500Name respName = new X500Name(tempCert.getSubjectX500Principal().getName());
                        if (!responderName.equals(respName)) continue;
                        signingCert = tempCert;
                        logger.log(Level.INFO, "Found a certificate whose principal \"{0}\" matches the responder name \"{1}\"", new Object[]{tempCert.getSubjectDN().getName(), responderName.toString()});
                        break;
                    }
                    catch (CertificateException e) {
                        logger.log(Level.FINE, e.getMessage());
                    }
                }
            } else if (responderKey != null) {
                SubjectKeyIdentifier responderSubjectKey = new SubjectKeyIdentifier(responderKey);
                logger.log(Level.INFO, "Responder Key: {0}", Arrays.toString(responderKey));
                for (X509CertificateHolder certHolder : certs) {
                    try {
                        X509Certificate tempCert = new JcaX509CertificateConverter().setProvider(BouncyIntegration.PROVIDER).getCertificate(certHolder);
                        SubjectKeyIdentifier subjectKeyIdentifier = null;
                        if (certHolder.getExtensions() != null) {
                            subjectKeyIdentifier = SubjectKeyIdentifier.fromExtensions(certHolder.getExtensions());
                        }
                        if (subjectKeyIdentifier != null) {
                            logger.log(Level.INFO, "Certificate: {0}\nSubject Key Id: {1}", new Object[]{tempCert.getSubjectDN().getName(), Arrays.toString(subjectKeyIdentifier.getKeyIdentifier())});
                        }
                        if (subjectKeyIdentifier != null && responderSubjectKey.equals(subjectKeyIdentifier)) {
                            signingCert = tempCert;
                            logger.log(Level.INFO, "Found a signer certificate \"{0}\" with the subject key extension value matching the responder key", ((X509Certificate)signingCert).getSubjectDN().getName());
                        } else {
                            subjectKeyIdentifier = new JcaX509ExtensionUtils().createSubjectKeyIdentifier(tempCert.getPublicKey());
                            if (!responderSubjectKey.equals(subjectKeyIdentifier)) continue;
                            signingCert = tempCert;
                            logger.log(Level.INFO, "Found a certificate \"{0}\" with the subject key matching the OCSP responder key", ((X509Certificate)signingCert).getSubjectDN().getName());
                        }
                        break;
                    }
                    catch (CertificateException e) {
                        logger.log(Level.FINE, e.getMessage());
                    }
                }
            }
        }
        if (signingCert != null) {
            if (signingCert.equals(issuerCertificate)) {
                logger.log(Level.INFO, "OCSP response is signed by the target''s Issuing CA");
            } else if (responderCertificate != null && signingCert.equals(responderCertificate)) {
                logger.log(Level.INFO, "OCSP response is signed by an authorized responder certificate");
            } else {
                if (!((X509Certificate)signingCert).getIssuerX500Principal().equals(issuerCertificate.getSubjectX500Principal())) {
                    logger.log(Level.INFO, "Signer certificate''s Issuer: {0}\nIssuer certificate''s Subject: {1}", new Object[]{((X509Certificate)signingCert).getIssuerX500Principal().getName(), issuerCertificate.getSubjectX500Principal().getName()});
                    throw new CertPathValidatorException("Responder's certificate is not authorized to sign OCSP responses");
                }
                try {
                    List<String> purposes = ((X509Certificate)signingCert).getExtendedKeyUsage();
                    if (purposes == null || !purposes.contains(KeyPurposeId.id_kp_OCSPSigning.getId())) {
                        logger.log(Level.INFO, "OCSPSigning extended usage is not set");
                        throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                    }
                }
                catch (CertificateParsingException e) {
                    logger.log(Level.FINE, "Failed to get certificate''s extended key usage extension\n{0}", e.getMessage());
                }
                if (date == null) {
                    ((X509Certificate)signingCert).checkValidity();
                } else {
                    ((X509Certificate)signingCert).checkValidity(date);
                }
                try {
                    Extension noOCSPCheck = new JcaX509CertificateHolder((X509Certificate)signingCert).getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck);
                    logger.log(Level.INFO, "OCSP no-check extension is {0} present", noOCSPCheck == null ? "not" : "");
                }
                catch (CertificateEncodingException e) {
                    logger.log(Level.FINE, "Certificate encoding exception: {0}", e.getMessage());
                }
                try {
                    signingCert.verify(issuerCertificate.getPublicKey());
                    logger.log(Level.INFO, "OCSP response is signed by an Authorized Responder");
                }
                catch (GeneralSecurityException ex) {
                    signingCert = null;
                }
            }
        }
        if (signingCert == null) {
            throw new CertPathValidatorException("Unable to verify OCSP Response's signature");
        }
        if (!this.verifySignature(basicOcspResponse, (X509Certificate)signingCert)) {
            throw new CertPathValidatorException("Error verifying OCSP Response's signature");
        }
        Extension responseNonce = basicOcspResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (responseNonce != null && requestNonce != null && !Arrays.equals(requestNonce, responseNonce.getExtnValue().getOctets())) {
            throw new CertPathValidatorException("Nonces do not match.");
        }
        long current = date == null ? System.currentTimeMillis() : date.getTime();
        Date date2 = new Date(current + 900000L);
        Date start = new Date(current - 900000L);
        Iterator<SingleResp> iter = Arrays.asList(basicOcspResponse.getResponses()).iterator();
        SingleResp singleRes = null;
        do {
            if (iter.hasNext()) continue;
            return;
        } while (!date2.before((singleRes = iter.next()).getThisUpdate()) && !start.after(singleRes.getNextUpdate() != null ? singleRes.getNextUpdate() : singleRes.getThisUpdate()));
        throw new CertPathValidatorException("Response is unreliable: its validity interval is out-of-date");
    }

    private boolean verifySignature(BasicOCSPResp basicOcspResponse, X509Certificate cert) {
        try {
            ContentVerifierProvider contentVerifier = new JcaContentVerifierProviderBuilder().setProvider(BouncyIntegration.PROVIDER).build(cert.getPublicKey());
            return basicOcspResponse.isSignatureValid(contentVerifier);
        }
        catch (OperatorCreationException e) {
            logger.log(Level.FINE, "Unable to construct OCSP content signature verifier\n{0}", e.getMessage());
        }
        catch (OCSPException e) {
            logger.log(Level.FINE, "Unable to validate OCSP response signature\n{0}", e.getMessage());
        }
        return false;
    }

    private OCSPProvider.OCSPRevocationStatus singleResponseToRevocationStatus(SingleResp singleResponse) throws CertPathValidatorException {
        CertificateStatus certStatus = singleResponse.getCertStatus();
        CRLReason revocationReason = CRLReason.UNSPECIFIED;
        Date revocationTime = null;
        OCSPProvider.RevocationStatus status = OCSPProvider.RevocationStatus.UNKNOWN;
        if (certStatus == CertificateStatus.GOOD) {
            status = OCSPProvider.RevocationStatus.GOOD;
        } else if (certStatus instanceof RevokedStatus) {
            RevokedStatus revoked = (RevokedStatus)certStatus;
            revocationTime = revoked.getRevocationTime();
            status = OCSPProvider.RevocationStatus.REVOKED;
            if (revoked.hasRevocationReason()) {
                revocationReason = CRLReason.values()[revoked.getRevocationReason()];
            }
        } else if (certStatus instanceof UnknownStatus) {
            status = OCSPProvider.RevocationStatus.UNKNOWN;
        } else {
            throw new CertPathValidatorException("Unrecognized revocation status received from OCSP.");
        }
        final OCSPProvider.RevocationStatus finalStatus = status;
        final Date finalRevocationTime = revocationTime;
        final CRLReason finalRevocationReason = revocationReason;
        return new OCSPProvider.OCSPRevocationStatus(){

            @Override
            public OCSPProvider.RevocationStatus getRevocationStatus() {
                return finalStatus;
            }

            @Override
            public Date getRevocationTime() {
                return finalRevocationTime;
            }

            @Override
            public CRLReason getRevocationReason() {
                return finalRevocationReason;
            }
        };
    }

    @Override
    protected List<String> getResponderURIs(X509Certificate cert) throws CertificateEncodingException {
        LinkedList<String> responderURIs = new LinkedList<String>();
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(cert);
        Extension aia = holder.getExtension(Extension.authorityInfoAccess);
        if (aia != null) {
            try {
                ASN1InputStream in = new ASN1InputStream(aia.getExtnValue().getOctetStream());
                ASN1Sequence seq = (ASN1Sequence)in.readObject();
                AuthorityInformationAccess authorityInfoAccess = AuthorityInformationAccess.getInstance(seq);
                for (AccessDescription ad : authorityInfoAccess.getAccessDescriptions()) {
                    if (!ad.getAccessMethod().equals(AccessDescription.id_ad_ocsp) || ad.getAccessLocation().getTagNo() != 6) continue;
                    DERIA5String value = DERIA5String.getInstance(ad.getAccessLocation().getName());
                    responderURIs.add(value.getString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responderURIs;
    }
}

