/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.credential;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.credential.dto.WebAuthnCredentialData;
import org.keycloak.models.credential.dto.WebAuthnSecretData;
import org.keycloak.util.JsonSerialization;

public class WebAuthnCredentialModel
extends CredentialModel {
    public static final String TYPE_TWOFACTOR = "webauthn";
    public static final String TYPE_PASSWORDLESS = "webauthn-passwordless";
    private final WebAuthnCredentialData credentialData;
    private final WebAuthnSecretData secretData;

    private WebAuthnCredentialModel(String credentialType, WebAuthnCredentialData credentialData, WebAuthnSecretData secretData) {
        this.credentialData = credentialData;
        this.secretData = secretData;
        this.setType(credentialType);
    }

    public static WebAuthnCredentialModel create(String credentialType, String userLabel, String aaguid, String credentialId, String attestationStatement, String credentialPublicKey, long counter, String attestationStatementFormat) {
        return WebAuthnCredentialModel.create(credentialType, userLabel, aaguid, credentialId, attestationStatement, credentialPublicKey, counter, attestationStatementFormat, Collections.emptySet());
    }

    public static WebAuthnCredentialModel create(String credentialType, String userLabel, String aaguid, String credentialId, String attestationStatement, String credentialPublicKey, long counter, String attestationStatementFormat, Set<String> transports) {
        WebAuthnCredentialData credentialData = new WebAuthnCredentialData(aaguid, credentialId, counter, attestationStatement, credentialPublicKey, attestationStatementFormat, transports);
        WebAuthnSecretData secretData = new WebAuthnSecretData();
        WebAuthnCredentialModel credentialModel = new WebAuthnCredentialModel(credentialType, credentialData, secretData);
        credentialModel.fillCredentialModelFields();
        credentialModel.setUserLabel(userLabel);
        return credentialModel;
    }

    public static WebAuthnCredentialModel createFromCredentialModel(CredentialModel credentialModel) {
        try {
            WebAuthnCredentialData credentialData = JsonSerialization.readValue(credentialModel.getCredentialData(), WebAuthnCredentialData.class);
            WebAuthnSecretData secretData = JsonSerialization.readValue(credentialModel.getSecretData(), WebAuthnSecretData.class);
            WebAuthnCredentialModel webAuthnCredentialModel = new WebAuthnCredentialModel(credentialModel.getType(), credentialData, secretData);
            webAuthnCredentialModel.setUserLabel(credentialModel.getUserLabel());
            webAuthnCredentialModel.setCreatedDate(credentialModel.getCreatedDate());
            webAuthnCredentialModel.setType(credentialModel.getType());
            webAuthnCredentialModel.setId(credentialModel.getId());
            webAuthnCredentialModel.setSecretData(credentialModel.getSecretData());
            webAuthnCredentialModel.setCredentialData(credentialModel.getCredentialData());
            return webAuthnCredentialModel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateCounter(long counter) {
        this.credentialData.setCounter(counter);
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString(this.credentialData));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WebAuthnCredentialData getWebAuthnCredentialData() {
        return this.credentialData;
    }

    public WebAuthnSecretData getWebAuthnSecretData() {
        return this.secretData;
    }

    private void fillCredentialModelFields() {
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString(this.credentialData));
            this.setSecretData(JsonSerialization.writeValueAsString(this.secretData));
            this.setCreatedDate(Time.currentTimeMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "WebAuthnCredentialModel { " + this.getType() + ", " + this.credentialData + ", " + this.secretData + " }";
    }
}

