/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.keycloak.util.KeycloakUriBuilder;

public class AbstractOAuthClient {
    private static final String OAUTH_TOKEN_REQUEST_STATE = "OAuth_Token_Request_State";
    private final AtomicLong counter = new AtomicLong();
    protected String clientId;
    protected Map<String, String> credentials;
    protected String authUrl;
    protected String codeUrl;
    protected String refreshUrl;
    protected boolean relativeUrls;
    protected String scope;
    protected String stateCookieName = "OAuth_Token_Request_State";
    protected String stateCookiePath;
    protected boolean isSecure;
    protected boolean publicClient;

    protected String getStateCode() {
        return this.counter.getAndIncrement() + "/" + UUID.randomUUID().toString();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Map<String, String> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public String getCodeUrl() {
        return this.codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public void setRefreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getStateCookieName() {
        return this.stateCookieName;
    }

    public void setStateCookieName(String stateCookieName) {
        this.stateCookieName = stateCookieName;
    }

    public String getStateCookiePath() {
        return this.stateCookiePath;
    }

    public void setStateCookiePath(String stateCookiePath) {
        this.stateCookiePath = stateCookiePath;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public boolean isRelativeUrls() {
        return this.relativeUrls;
    }

    public void setRelativeUrls(boolean relativeUrls) {
        this.relativeUrls = relativeUrls;
    }

    protected String stripOauthParametersFromRedirect(String uri) {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri(uri).replaceQueryParam("code", null).replaceQueryParam("state", null);
        return builder.build(new Object[0]).toString();
    }
}

