/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;

public class JWKSUtils {
    private static final Logger logger = Logger.getLogger((String)JWKSUtils.class.getName());

    @Deprecated
    public static Map<String, PublicKey> getKeysForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        return JWKSUtils.getKeyWrappersForUse(keySet, requestedUse).getKeys().stream().collect(Collectors.toMap(KeyWrapper::getKid, keyWrapper -> (PublicKey)keyWrapper.getPublicKey()));
    }

    public static PublicKeysWrapper getKeyWrappersForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        return JWKSUtils.getKeyWrappersForUse(keySet, requestedUse, false);
    }

    public static PublicKeysWrapper getKeyWrappersForUse(JSONWebKeySet keySet, JWK.Use requestedUse, boolean useRequestedUseWhenNull) {
        ArrayList<KeyWrapper> result = new ArrayList<KeyWrapper>();
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (jwk.getPublicKeyUse() == null && !useRequestedUseWhenNull) {
                logger.debugf("Ignoring JWK key '%s'. Missing required field 'use'.", (Object)jwk.getKeyId());
                continue;
            }
            if (!requestedUse.asString().equals(jwk.getPublicKeyUse()) && (jwk.getPublicKeyUse() != null || !useRequestedUseWhenNull) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            KeyWrapper keyWrapper = new KeyWrapper();
            keyWrapper.setKid(jwk.getKeyId());
            if (jwk.getAlgorithm() != null) {
                keyWrapper.setAlgorithm(jwk.getAlgorithm());
            }
            keyWrapper.setType(jwk.getKeyType());
            keyWrapper.setUse(JWKSUtils.getKeyUse(requestedUse.asString()));
            keyWrapper.setPublicKey(parser.toPublicKey());
            result.add(keyWrapper);
        }
        return new PublicKeysWrapper(result);
    }

    private static KeyUse getKeyUse(String keyUse) {
        switch (keyUse) {
            case "sig": {
                return KeyUse.SIG;
            }
            case "enc": {
                return KeyUse.ENC;
            }
        }
        return null;
    }

    public static JWK getKeyForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (jwk.getPublicKeyUse() == null) {
                logger.debugf("Ignoring JWK key '%s'. Missing required field 'use'.", (Object)jwk.getKeyId());
                continue;
            }
            if (!requestedUse.asString().equals(parser.getJwk().getPublicKeyUse()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            return jwk;
        }
        return null;
    }
}

