/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import java.io.File;
import java.nio.file.Files;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.keycloak.guides.maven.DirectoryCopyVisitor;
import org.keycloak.guides.maven.GuideBuilder;

@Mojo(name="keycloak-guide", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GuideMojo
extends AbstractMojo {
    @Parameter(property="project.build.sourceDirectory")
    private String sourceDir;
    @Parameter(property="project.build.directory")
    private String targetDir;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoFailureException {
        try {
            Log log = this.getLog();
            File topDir = new File(this.sourceDir);
            for (File srcDir : topDir.listFiles(d -> d.isDirectory() && !d.getName().equals("templates"))) {
                if (srcDir.getName().equals("target") || srcDir.getName().equals("src")) continue;
                File targetDir = new File(new File(this.targetDir, "generated-guides"), srcDir.getName());
                if (!targetDir.isDirectory()) {
                    targetDir.mkdirs();
                }
                if (srcDir.getName().equals("images")) {
                    log.info((CharSequence)("Copy files from " + srcDir + " to " + targetDir));
                    Files.walkFileTree(srcDir.toPath(), new DirectoryCopyVisitor(targetDir.toPath()));
                    continue;
                }
                log.info((CharSequence)("Guide dir: " + srcDir.getAbsolutePath()));
                log.info((CharSequence)("Target dir: " + targetDir.getAbsolutePath()));
                GuideBuilder g = new GuideBuilder(srcDir, targetDir, log, this.project.getProperties());
                g.build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to generated asciidoc files", (Throwable)e);
        }
    }
}

