/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.events.AuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.InfinispanKeycloakTransaction;
import org.keycloak.models.sessions.infinispan.RootAuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.stream.RootAuthenticationSessionPredicate;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.utils.SessionExpiration;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class InfinispanAuthenticationSessionProvider
implements AuthenticationSessionProvider {
    private static final Logger log = Logger.getLogger(InfinispanAuthenticationSessionProvider.class);
    private final KeycloakSession session;
    private final Cache<String, RootAuthenticationSessionEntity> cache;
    private final InfinispanKeyGenerator keyGenerator;
    private final int authSessionsLimit;
    protected final InfinispanKeycloakTransaction tx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;

    public InfinispanAuthenticationSessionProvider(KeycloakSession session, InfinispanKeyGenerator keyGenerator, Cache<String, RootAuthenticationSessionEntity> cache, int authSessionsLimit) {
        this.session = session;
        this.cache = cache;
        this.keyGenerator = keyGenerator;
        this.authSessionsLimit = authSessionsLimit;
        this.tx = new InfinispanKeycloakTransaction();
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm) {
        String id = this.keyGenerator.generateKeyString(this.session, this.cache);
        return this.createRootAuthenticationSession(realm, id);
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm, String id) {
        RootAuthenticationSessionEntity entity = new RootAuthenticationSessionEntity();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setTimestamp(Time.currentTime());
        int expirationSeconds = SessionExpiration.getAuthSessionLifespan((RealmModel)realm);
        this.tx.put(this.cache, id, entity, expirationSeconds, TimeUnit.SECONDS);
        return this.wrap(realm, entity);
    }

    private RootAuthenticationSessionAdapter wrap(RealmModel realm, RootAuthenticationSessionEntity entity) {
        return entity == null ? null : new RootAuthenticationSessionAdapter(this.session, this, this.cache, realm, entity, this.authSessionsLimit);
    }

    private RootAuthenticationSessionEntity getRootAuthenticationSessionEntity(String authSessionId) {
        RootAuthenticationSessionEntity entity = this.tx.get(this.cache, authSessionId);
        return entity;
    }

    public void removeAllExpired() {
    }

    public void removeExpired(RealmModel realm) {
    }

    public void onRealmRemoved(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RealmRemovedSessionEvent.createEvent(RealmRemovedSessionEvent.class, "REALM_REMOVED_EVENT_AUTHSESSIONS", this.session, realm.getId(), false), ClusterProvider.DCNotify.ALL_DCS);
    }

    protected void onRealmRemovedEvent(String realmId) {
        Iterator itr = CacheDecorators.localCache(this.cache).entrySet().stream().filter((Predicate)RootAuthenticationSessionPredicate.create(realmId)).iterator();
        while (itr.hasNext()) {
            CacheDecorators.localCache(this.cache).remove(((Map.Entry)itr.next()).getKey());
        }
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    protected void onClientRemovedEvent(String realmId, String clientUuid) {
    }

    public void updateNonlocalSessionAuthNotes(AuthenticationSessionCompoundId compoundId, Map<String, String> authNotesFragment) {
        if (compoundId == null) {
            return;
        }
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify("AUTHENTICATION_SESSION_EVENTS", (ClusterEvent)AuthenticationSessionAuthNoteUpdateEvent.create(compoundId.getRootSessionId(), compoundId.getTabId(), compoundId.getClientUUID(), authNotesFragment), true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }

    public RootAuthenticationSessionModel getRootAuthenticationSession(RealmModel realm, String authenticationSessionId) {
        RootAuthenticationSessionEntity entity = this.getRootAuthenticationSessionEntity(authenticationSessionId);
        return this.wrap(realm, entity);
    }

    public void removeRootAuthenticationSession(RealmModel realm, RootAuthenticationSessionModel authenticationSession) {
        this.tx.remove(this.cache, authenticationSession.getId());
    }

    public void close() {
    }

    public Cache<String, RootAuthenticationSessionEntity> getCache() {
        return this.cache;
    }

    protected String generateTabId() {
        return Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes(8));
    }
}

