/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.resource.delegate;

import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.authorization.entity.MapResourceEntityFields;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.storage.jpa.JpaDelegateProvider;
import org.keycloak.models.map.storage.jpa.authorization.resource.entity.JpaResourceEntity;

public class JpaResourceDelegateProvider
extends JpaDelegateProvider<JpaResourceEntity>
implements DelegateProvider<MapResourceEntity> {
    private final EntityManager em;

    public JpaResourceDelegateProvider(JpaResourceEntity delegate, EntityManager em) {
        super(delegate);
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapResourceEntity getDelegate(boolean isRead, Enum<? extends EntityField<MapResourceEntity>> field, Object ... parameters) {
        if (((JpaResourceEntity)this.getDelegate()).isMetadataInitialized()) {
            return (MapResourceEntity)this.getDelegate();
        }
        if (isRead) {
            if (!(field instanceof MapResourceEntityFields)) throw new IllegalStateException("Not a valid resource field: " + field);
            switch ((MapResourceEntityFields)field) {
                case ID: 
                case NAME: 
                case TYPE: 
                case OWNER: 
                case REALM_ID: 
                case RESOURCE_SERVER_ID: {
                    return (MapResourceEntity)this.getDelegate();
                }
                case ATTRIBUTES: {
                    CriteriaBuilder cb = this.em.getCriteriaBuilder();
                    CriteriaQuery query = cb.createQuery(JpaResourceEntity.class);
                    Root root = query.from(JpaResourceEntity.class);
                    root.fetch("attributes", JoinType.LEFT);
                    query.select((Selection)root).where((Expression)cb.equal((Expression)root.get("id"), (Object)UUID.fromString(((JpaResourceEntity)this.getDelegate()).getId())));
                    this.setDelegate((JpaResourceEntity)this.em.createQuery(query).getSingleResult());
                    return (MapResourceEntity)this.getDelegate();
                }
                default: {
                    this.setDelegate((JpaResourceEntity)this.em.find(JpaResourceEntity.class, (Object)UUID.fromString(((JpaResourceEntity)this.getDelegate()).getId())));
                    return (MapResourceEntity)this.getDelegate();
                }
            }
        } else {
            this.setDelegate((JpaResourceEntity)this.em.find(JpaResourceEntity.class, (Object)UUID.fromString(((JpaResourceEntity)this.getDelegate()).getId())));
        }
        return (MapResourceEntity)this.getDelegate();
    }
}

